/*    Script um einen neue TimeSafe Datenbank zu erstellen     	 			      */

/*    Driver Used : Visio Enterprise - Microsoft SQL Server Driver.                           */
/*    Document    : h:\work\infotech\produkte\z2\projektordner\4_architektur\datenmodell.vsd. */
/*    Time Created: 3. July 2001 13:55.                                                       */
/*    Operation   : From Visio Generate Wizard.                                               */
/*    Connected data source : No connection.                                                  */
/*    Connected server      : No connection.                                                  */
/*    Connected database    : Not applicable.                                                 */


/* Create TimeSafe database.                                                                  */
use master  
go

create database TimeSafe
go

-- Automatisches Schliessen der Datenbank verhindern
alter database TimeSafe SET AUTO_CLOSE OFF
go

use TimeSafe
go

/* Create new table tMasterTextTemplates.                                               */
/* 	lMasterTextTemplateID : lMasterTextTemplateID identifies tMasterTextTemplates   */
/* 	strShortCut : strShortCut is of tMasterTextTemplates                            */  
/* 	strText : strText is of tMasterTextTemplates                               	*/  
/*	lServiceTypeCode : lServiceTypeCode is of tMasterTextTemplates			*/
create table tMasterTextTemplates ( 
	lMasterTextTemplateID int identity not null, 
	strShortCut varchar(10) null,  
	strText varchar(5000) not null, 
	lServiceTypeCode int not null)  
go

alter table tMasterTextTemplates
	add constraint tMasterTextTemplates_PK primary key clustered (lMasterTextTemplateID)   
go


/* INSERT TRIGGER um zu gewhrleisten, dass ein Krzel fr die Vorlagen
   NULL sein kann, aber eindeutig sein muss, falls definiert 
   
   Autor:	Mike Kaufmann
   Datum:	2005-02-08
*/
CREATE TRIGGER tMasterTextTemplatesins ON tMasterTextTemplates for insert
as
     declare @errorNumber int,
    	     @errorMsg varchar(255)
begin

  /* trigger for insert */
  if not (select strShortCut FROM inserted) is null
  begin
   if (select count(*) from inserted, tMasterTextTemplates
    where (tMasterTextTemplates.strShortCut = inserted.strShortCut) ) > 1
    begin
      select @errorNumber = 30002, @errorMsg = 'Das Krzel muss eindeutig sein!'
      goto errorHandler
    end
  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO

/* UPDATE TRIGGER um zu gewhrleisten, dass ein Krzel fr die Vorlagen
   NULL sein kann, aber eindeutig sein muss, falls definiert 
   
   Autor:	Mike Kaufmann
   Datum:	2005-02-08
*/
CREATE Trigger tMasterTextTemplatesupd on tMasterTextTemplates
for update 
as
BEGIN
  declare
	@rowsAffected int,
	@nullRows int,
	@validRows int, 
	@errorNumber int,
	@errorMsg varchar(255)

  select @rowsAffected = @@rowcount

/* UPDATE Trigger von strClientNo */
if
update(strShortCut)
  begin
    if not (select strShortCut FROM inserted) is null
    begin
      if (select count(*) from inserted, tMasterTextTemplates
          where (tMasterTextTemplates.strShortCut = inserted.strShortCut) ) > 1
        begin
          select @errorNumber = 30002,
                 @errorMsg = 'Das Krzel muss eindeutig sein!'
          goto errorHandler
        end
    end
  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO




/* Create new table tDepartment.                                                        */
/* tDepartment : tDepartment of tDepartment                                             */
/* 	lDepartmentID : lDepartmentID identifies tDepartment                   		*/
/* 	strDesignation : strDesignation is of tDepartment                               */  
create table tDepartment ( 
	lDepartmentID int identity not null, 
	strDesignation varchar(100) not null)  
go

alter table tDepartment
	add constraint tDepartment_PK primary key clustered (lDepartmentID)   
go

/* Create new table tInvoiceRptDefinition                                               	*/
/* tInvoiceRptDefinition : tInvoiceRptDefinition of tInvoiceRptDefinition          		*/
/* 	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID identifies tInvoiceRptDefinition	*/
/* 	lLanguageID : lLanguageID is of tInvoiceRptDefinition					*/
/* 	strDesignation : strDesignation is of tInvoiceRptDefinition                            	*/  
/* 	strInvoiceText : strInvoiceText is of tInvoiceRptDefinition                            	*/  
/* 	strDesignation : strDesignation is of tInvoiceRptDefinition                            	*/  
/*	strTimeServices : strTimeServices is of tInvoiceRptDefinition				*/
/*	strExpServices : strExpServices is of tInvoiceRptDefinition				*/
/*	strMatServices : strMatServices is of tInvoiceRptDefinition				*/
/*	strLumpSums : strLumpSums is of tInvoiceRptDefinition					*/
/*	strFees : strFees is of tInvoiceRptDefinition						*/
/*	strProjectLabel : strProjectLabel is of tInvoiceRptDefinition				*/
/*	strAccPayments : strAccPayments is of tInvoiceRptDefinition				*/
/*	strTaxRate : strTaxRate is of tInvoiceRptDefinition					*/
create table tInvoiceRptDefinition ( 
	lInvoiceRptDefinitionID int identity not null,
	lLanguageID int null, 
	strDesignation varchar(100) not null, 
	strInvoiceText varchar(500) null,
	strInvoiceRemarks varchar(500) null,
	strTimeServices varchar(100) null, 
	strExpServices varchar(100) null,
	strMatServices varchar(100) null,
	strLumpSums varchar(100) null,
	strFees varchar(100) null,
	strProjectLabel varchar(100) null,
	strAccPayments varchar(100) null,
	strTaxRate varchar(100) null)  
go

alter table tInvoiceRptDefinition
	add constraint tInvoiceRptDefinition_PK primary key clustered (lInvoiceRptDefinitionID)   
go

/* Create new table tPrinter                                               		*/
/* tPrinter : tPrinter of tPrinter          					*/
/* 	lPrinterID : lPrinterID identifies tPrinter                   			*/
/* 	strDesignation : strDesignation is of tPrinter                               	*/  
/* 	strDeviceName : strDeviceName is of tPrinter                               	*/  
/* 	lCopies : lCopies is of tPrinter                               	*/  
/* 	lPaperBinCode : lPaperBinCode is of tPrinter                               	*/  
/* 	strPaperBin : strPaperBin is of tPrinter                               	*/  
create table tPrinter ( 
	lPrinterID int identity not null, 
	strDesignation varchar(200) not null,
	strDeviceName varchar(200) not null,
	lCopies int not null,
	lPaperBinCode int null,
	strPaperBin varchar(200) null)  
go

alter table tPrinter
	add constraint tPrinter_PK primary key clustered (lPrinterID)   
go

/* Create new table tInvoiceRptFile                                            		*/
/* tInvoiceRptFile : tInvoiceRptFile of tInvoiceRptFile     			*/
/* 	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID identifies tInvoiceRptFile    */
/* 	lSheetType : lSheetType identifies tInvoiceRptFile                             	*/  
/* 	lPrinterID : lPrinterID is of tInvoiceRptFile                               	*/  
/* 	strInvRptFile : strInvRptFile is of tInvoiceRptFile                             */  
/* 	lIndRptID : lIndRptID is of tInvoiceRptFile                               	*/  
create table tInvoiceRptFile ( 
	lInvoiceRptDefinitionID int not null, 
	lSheetType int not null constraint tInvoiceRptFilelSheetType_Chk check (lSheetType between 1 and 9),
	lPrinterID int null,
	strInvRptFile varchar(200) not null,
	lIndRptID int null)  
go

alter table tInvoiceRptFile
	add constraint tInvoiceRptFile_PK primary key clustered (lInvoiceRptDefinitionID, lSheetType)   
go


/* Create new table tTimeSrvRpt                                            		*/
/* tTimeSrvRpt : tTimeSrvRpt of tTimeSrvRpt     					*/
/* 	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID identifies tTimeSrvRpt    	*/
/* 	lSheetType : lSheetType identifies tTimeSrvRpt                             	*/
/* 	bDspEffectiveDuration : bDspEffectiveDuration is of tTimeSrvRpt                 */  
/* 	bDspGlobalInvEntries : bDspGlobalInvEntries is of tTimeSrvRpt                 	*/  
/* 	bGroupByProjectGroups : bGroupByProjectGroups is of tTimeSrvRpt                 */  
/* 	bDspTextOnly : bDspTextOnly is of tTimeSrvRpt                 			*/  
/* 	bDspNoText : bDspNoText is of tTimeSrvRpt                 			*/  
create table tTimeSrvRpt ( 
	lInvoiceRptDefinitionID int not null, 
	lSheetType int not null constraint tTimeSrvRptlSheetType_Chk check (lSheetType=3), 
	bDspEffectiveDuration bit not null,
	bDspGlobalInvEntries bit not null,
	bGroupByProjectGroups bit not null,
	bDspTextOnly bit not null,
	bDspNoText bit not null)  
go

alter table tTimeSrvRpt
	add constraint tTimeSrvRpt_PK primary key clustered (lInvoiceRptDefinitionID, lSheetType)   
go

/* Create new table tExpenseSrvRpt                                            		*/
/* tExpenseSrvRpt : tExpenseSrvRpt of tExpenseSrvRpt     				*/
/* 	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID identifies tExpenseSrvRpt    	*/
/* 	lSheetType : lSheetType identifies tExpenseSrvRpt                             	*/
/* 	bDspEffectiveAmount : bDspEffectiveAmount is of tExpenseSrvRpt                 	*/  
/* 	bDspGlobalInvEntries : bDspGlobalInvEntries is of tExpenseSrvRpt                */  
create table tExpenseSrvRpt ( 
	lInvoiceRptDefinitionID int not null, 
	lSheetType int not null constraint tExpenseSrvRptlSheetType_Chk check (lSheetType=4), 
	bDspEffectiveAmount bit not null,
	bDspGlobalInvEntries bit not null)  
go

alter table tExpenseSrvRpt
	add constraint tExpenseSrvRpt_PK primary key clustered (lInvoiceRptDefinitionID, lSheetType)   
go

/* Create new table tMaterialSrvRpt                                            		*/
/* tMaterialSrvRpt : tMaterialSrvRpt of tMaterialSrvRpt     				*/
/* 	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID identifies tExpenseSrvRpt    	*/
/* 	lSheetType : lSheetType identifies tExpenseSrvRpt                             	*/
/* 	bDspEffectiveAmount : bDspEffectiveAmount is of tMaterialSrvRpt                 */  
create table tMaterialSrvRpt ( 
	lInvoiceRptDefinitionID int not null, 
	lSheetType int not null constraint tMaterialSrvRptlSheetType_Chk check (lSheetType=5),  
	bDspEffectiveAmount bit not null)  
go

alter table tMaterialSrvRpt
	add constraint tMaterialSrvRpt_PK primary key clustered (lInvoiceRptDefinitionID, lSheetType)   
go


/* Create new table tTasks.                                                             */
/* tTasks : Table of tTasks                                                      	*/
/* 	lTaskID : lTaskID identifies tTasks                            			*/
/* 	lCreatorID : lCreatorID is of tTasks                                           	*/
/* 	lResponsibleID : lResponsibleID is of tTasks                                    */
/* 	lContactID : lContactID is of tTasks                                       	*/  
/* 	lProjectID : lProjectID is of tTasks                                       	*/  
/*	dtCreation : dtCreation is of tTasks						*/
/* 	strSubject : strSubject is of tTasks                                       	*/  
/* 	dtDueDate : dtDueDate is of tTasks                                       	*/  
/* 	dtStart : dtStart is of tTasks                                       		*/  
/* 	dtEnd : dtEnd is of tTasks                                       		*/  
/* 	dtRemember : dtRemember is of tTasks                                       	*/  
/* 	dtRememberAgain : dtRememberAgain is of tTasks                                  */  
/* 	tinState : tinState is of tTasks                                       		*/  
/* 	tinPriority : tinPriority is of tTasks                                       	*/  
/* 	lDone : lDone is of tTasks                                       		*/
/* 	lInterval : lInterval is of tTasks                                       	*/  
/* 	tinIntervalUnit : tinIntervalUnit is of tTasks                                  */    
/* 	strText : strText is of tTasks                                       		*/  
create table tTasks ( 
	lTaskID int identity not null,
	lCreatorID int not null,
	lResponsibleID int not null,
	lContactID int null,
	lProjectID int null,
	dtCreation smalldatetime not null,
	strSubject varchar(100) not null,
	dtDueDate smalldatetime null,
	dtStart smalldatetime null,
	dtEnd smalldatetime null,
	dtRemember smalldatetime null,
	dtRememberAgain smalldatetime null,
	tinState tinyint not null constraint tTaskstinState_Chk check (tinState between 1 and 4),
	tinPriority tinyint not null constraint tTaskstinPriority_Chk check (tinPriority between 1 and 3),
	lDone int not null,
	lInterval int null,
	tinIntervalUnit tinyint null constraint tTaskstinIntervalUnit_Chk check (tinIntervalUnit between 1 and 3),
	strText varchar(5000) null)  

go

alter table tTasks
	add constraint tTasks_PK primary key clustered (lTaskID)   


go

/* Create new table tEmployment.                                                              */
/* tEmployment : Table of tEmployment                                                         */
/* 	lEmploymentID : lEmploymentID identifies tEmployment                                  */
/* 	lEmployeeID : lEmployeeID is of tEmployment                                           */
/* 	dtValidFrom : dtValidFrom is of tEmployment                                           */
/* 	decPercent : decPercent is of tEmployment                                             */  
create table tEmployment ( 
	lEmploymentID int identity not null,
	lEmployeeID int not null,
	dtValidFrom smalldatetime not null,
	decPercent decimal(9,2) not null)  

go

alter table tEmployment
	add constraint tEmployment_PK primary key clustered (lEmploymentID)   


go


/* Create new table tIntHourlyRate.                                                              */
/* tIntHourlyRate : Table of tIntHourlyRate                                                      */
/* 	lIntHourlyRateID : lIntHourlyRateID identifies tIntHourlyRate                            */
/* 	lEmployeeID : lEmployeeID is of tIntHourlyRate                                           */
/* 	dtValidFrom : dtValidFrom is of tIntHourlyRate                                           */
/* 	decHourlyRate : decHourlyRate is of tIntHourlyRate                                       */  
create table tIntHourlyRate ( 
	lIntHourlyRateID int identity not null,
	lEmployeeID int not null,
	dtValidFrom smalldatetime not null,
	decHourlyRate decimal(9,2) not null)  

go

alter table tIntHourlyRate
	add constraint tIntHourlyRate_PK primary key clustered (lIntHourlyRateID)   


go


/* Create new table tAuthorisationGroup.                                                         */
/* tAuthorisationGroup : Table of tAuthorisationGroup                                            */
/* 	lAuthorisationGroupID : lAuthorisationGroupID identifies tAuthorisationGroup             */
/* 	strDesignation : strDesignation is of tAuthorisationGroup                                */
/* 	strRights : strRights is of tAuthorisationGroup                                          */
create table tAuthorisationGroup ( 
	lAuthorisationGroupID int identity not null,
	strDesignation varchar(100) not null,
	strRights varchar(100) not null)  

go

alter table tAuthorisationGroup
	add constraint tAuthorisationGroup_PK primary key clustered (lAuthorisationGroupID)   
go


/* Create new table tScale.                             		                        */
/* tScale : Table of tScale				                                        */
/* 	lScaleID : lScaleID identifies tScale             					*/
/* 	strDesignation : strDesignation is of tScale                                		*/
/* 	bUsed : bUsed is of tScale                                          			*/
/* 	lSortKey : lSortKey is of tScale                                         		*/
create table tScale ( 
	lScaleID int not null,
	strDesignation varchar(100) not null,
	bUsed bit not null,
	lSortKey int not null)  

go

alter table tScale
	add constraint tScale_PK primary key clustered (lScaleID)   
go


/* Create new table tBookingsLog.                                                             */
/* tBookingsLog : Table of tBookingsLog                                                       */
/* 	lBookingsLogID : lBookingsLogID identifies tBookingsLog                                   */
/* 	lBookingID : lBookingID is of tBookingsLog                                                */
/* 	strText : strText is of tBookingsLog                                                      */  
create table tBookingsLog ( 
	lBookingsLogID int identity not null,
	lBookingID int not null,
	strText varchar(500) not null)  

go

alter table tBookingsLog
	add constraint tBookingsLog_PK primary key clustered (lBookingsLogID)   


go


/* Create new table tBookings.                                                                */
/* tBookings : Table of tBookings                                                             */
/* 	lBookingID : lBookingID identifies tBookings                                              */
/* 	lEmployeeID : lEmployeeID is of tBookings                                                 */
/* 	dtDate : dtDate is of tBookings                                                           */  
create table tBookings ( 
	lBookingID int identity not null,
	lEmployeeID int not null,
	dtDate smalldatetime not null)  

go

alter table tBookings
	add constraint tBookings_PK primary key clustered (lBookingID)


/* Create new table tPayments.                                                                */
/* tPayments : Table of tPayments                                                             */
/* 	lPaymentID : lPaymentID identifies tPayments                                              */
/* 	lInvoiceID : lInvoiceID is of tPayments                                                   */
/* 	lAccountNoID : lAccountNoID is of tPayments                                               */
/* 	dtDate : dtDate is of tPayments                                                           */
/* 	decAmount : decAmount is of tPayments                                                     */
/* 	lDocumentNo : lDocumentNo is of tPayments                                                 */    
create table tPayments ( 
	lPaymentID int identity not null,
	lInvoiceID int not null,
	lAccountNoID int not null,
	dtDate smalldatetime not null,
	decAmount decimal(9,2) not null,
	lDocumentNo int null) ON 'PRIMARY'  

go

alter table tPayments
	add constraint tPayments_PK primary key clustered (lPaymentID)   


go

/* Create new table tFees.                                                                    */
/* tFees : In dieser Tabelle werden die verrechneten und zu verrechnenden Honorare abgelegt (History) */
/* 	Dies geschieht immer, wenn in den Punkt Fakturierung eingestiegen wird.                   */
/* 	lFeeID : lFeeID identifies tFees                                                          */
/* 	lFeeTaskID : lFeeTaskID is of tFees                                                       */
/* 	lInvoiceID : lInvoiceID is of tFees                                                       */
/* 	lCurrencyID : lCurrencyID is of tFees                                                     */
/* 	dtDueDate : dtDueDate is of tFees                                                         */
/* 	decAmount : decAmount is of tFees                                                         */
/* 	dtInvoicedAt : dtInvoicedAt is of tFees                                                   */
/* 	decTaxRate : decTaxRate is of tFees                                                       */
/* 	strText : strText is of tFees                                                             */  
/* 	strIntText : strIntText is of tFees                                                       */
create table tFees ( 
	lFeeID int identity not null,
	lFeeTaskID int not null,
	lInvoiceID int null,
	lCurrencyID int not null,
	dtDueDate datetime not null,
	decAmount decimal(9,2) not null,
	dtInvoicedAt datetime null,
	decTaxRate decimal(9,2) null,
	strText varchar(600) not null,
	strIntText varchar(500) null) ON 'PRIMARY'  

go

alter table tFees
	add constraint tFees_PK primary key clustered (lFeeID)   


go

/* Create new table tCreditBalanceCorrections.                                                */
/* tCreditBalanceCorrections : Saldokorrekturen (z.Bsp. bei Systembernahme)                  */
/* 	betrifft Zeit- und Feriensaldo                                                            */
/* 	lCredBalCorrID : lCredBalCorrID identifies tCreditBalanceCorrections                      */
/* 	lEmployeeID : lEmployeeID is of tCreditBalanceCorrections                                 */
/* 	lTimeCorr : lTimeCorr is of tCreditBalanceCorrections                                     */
/* 	decHolidayClaim : decHolidayClaim is of tCreditBalanceCorrections                               */
/* 	decCarry : decCarry is of tCreditBalanceCorrections                               */
/* 	dtDate : dtDate is of tCreditBalanceCorrections                                           */
/* 	strRemarks : strRemarks is of tCreditBalanceCorrections                                   */  
create table tCreditBalanceCorrections ( 
	lCredBalCorrID int identity not null,
	lEmployeeID int not null,
	lTimeCorr int null,
	decHolidayClaim decimal(9,2) null,
	decCarry decimal(9,2) null,
	dtDate smalldatetime not null,
	strRemarks varchar(500) null) ON 'PRIMARY'  

go

alter table tCreditBalanceCorrections
	add constraint tCreditBalanceCorrections_PK primary key clustered (lCredBalCorrID)   


go

/* Create new table tFavorites.                                                               	*/
/* tFavorites : Ttigkeiten von Projekten werden als Favoriten gespeichert                    	*/
/* 	(1:1 Beziehung)                                                                         */
/* 	lFavoriteID : Hier wird eine in der Settings Tabelle vorgegebene maximale Anzahl von Ttigkeiten in Projekten als Favorit abgelegt. */
/* 	lActivityID : lActivityID is of tFavorites                                              */
/* 	lEmployeeID : lEmployeeID is of tFavorites                                              */
/* 	lSortOrder : lSortOrder is of tFavorites                                                */  
/*	strDesignation : strDesignation is of tFavorites					*/
create table tFavorites ( 
	lFavoriteID int identity not null,
	lActivityID int not null,
	lEmployeeID int not null,
	lSortOrder int not null, 
	strDesignation varchar(200) not null) ON 'PRIMARY'  

go

alter table tFavorites
	add constraint tFavorites_PK primary key clustered (lFavoriteID)   


go

/* Create new table tTaxKeyValidities.                                                        */
/* tTaxKeyValidities : Gltigkeiten der Mehrwertschlssel.                                    */
/* 	Jeder Mehrwertschlssel hat Prozentstze, die                                             */
/* 	eine bestimmte Dauer gltig sind:                                                         */
/* 	Beispiel:                                                                                 */
/* 	  Umsatzsteuer normal:        7.5 %         Gltig ab: 01.01.1998                         */
/* 	                                            7.6 %         Gltig ab: 01.01.2001           */
/* 	lTaxKeyValidityID : lTaxKeyValidityID identifies tTaxKeyValidities                        */
/* 	lTaxKeyID : lTaxKeyID is of tTaxKeyValidities                                             */
/* 	decPercentage : decPercentage is of tTaxKeyValidities                                     */
/* 	dtValidFrom : dtValidFrom is of tTaxKeyValidities                                         */  
create table tTaxKeyValidities ( 
	lTaxKeyValidityID int identity not null,
	lTaxKeyID int not null,
	decPercentage decimal(9,2) not null,
	dtValidFrom smalldatetime not null) ON 'PRIMARY'  

go

alter table tTaxKeyValidities
	add constraint tTaxKeyValidities_PK primary key clustered (lTaxKeyValidityID)   


go

/* Create new table tLanguages.                                                               */
/* tLanguages : Die Stammdaten der Whrungen werden abgespeichert.                            */
/* 	lLanguageID : lLanguageID identifies tLanguages                                           */
/* 	strDesignation : strDesignation is of tLanguages                                          */
/* 	bInvoiceOnly : bInvoiceOnly is of tLanguages                                              */  
create table tLanguages ( 
	lLanguageID int not null,
	strDesignation varchar(100) not null,
	bInvoiceOnly bit not null) ON 'PRIMARY'  

go

alter table tLanguages
	add constraint tLanguages_PK primary key clustered (lLanguageID)   


go

/* Create new table tSettings.                                                                */
/* tSettings : Hier werden die Systemeinstellungen abgespeichert.                             */
/* 	Die gesetzte Whrung, die aktuelle Sprache, Arbeitszeit pro Woche, zu verwendende Konti, etc. */
/* 	lSettingID : lSettingID identifies tSettings                                              */
/* 	lValue : lValue is of tSettings                                                           */
/* 	strValue : strValue is of tSettings                                                       */
/* 	dblValue : dblValue is of tSettings                                                       */
/* 	dtValue : dtValue is of tSettings                                                         */
/* 	bValue : bValue is of tSettings                                                           */
/* 	imgValue : imgValue is of tSettings                                                       */
/* 	strDescription : strDescription is of tSettings                                           */  
create table tSettings ( 
	lSettingID int not null,
	lValue int null,
	strValue varchar(500) null,
	dblValue decimal(9,2) null,
	dtValue datetime null,
	bValue bit not null,
	imgValue image null,
	strDescription varchar(100) null) ON 'PRIMARY' TEXTIMAGE_ON 'PRIMARY'  

go

alter table tSettings
	add constraint tSettings_PK primary key clustered (lSettingID)   


go

/* Create new table tLicenseKey.                                                              */
/* tLicenseKey : Der Lizenzschlssel,                                                         */
/* 	der die Anzahl Benutzerlizenzen,                                                          */
/* 	die ProduktNr, das Gltigkeitsdatum und                                                   */
/* 	die Firma die das Produkt lizenziert hat beinhaltet.                                      */
/* 	strLicenseKey : strLicenseKey identifies tLicenseKey                                      */  
create table tLicenseKey ( 
	strLicenseKey varchar(100) not null) ON 'PRIMARY'  

go

alter table tLicenseKey
	add constraint tLicenseKey_PK primary key clustered (strLicenseKey)   


go

/* Create new table tToolsLoaded.                                                             */
/* tToolsLoaded : Liste der Tools, die als geladen gekennzeichnet sind, das heisst, sie werden in dem dynamischen Menu angezeigt. */
/* 	lToolLoadedID : lToolLoadedID identifies tToolsLoaded                                     */
/* 	lToolID : lToolID is of tToolsLoaded                                                      */  
create table tToolsLoaded ( 
	lToolLoadedID int identity not null,
	lToolID int not null) ON 'PRIMARY'  

go

alter table tToolsLoaded
	add constraint tToolsLoaded_PK primary key clustered (lToolLoadedID)   


go

/* Create new table tTools.                                                                   */
/* tTools : Liste der pro Mitarbeiter verfgbaren Tools                                       */
/* 	lToolID : lToolID identifies tTools                                                       */
/* 	lEmployeeID : lEmployeeID is of tTools                                                    */
/* 	strDesignation : strDesignation is of tTools                                              */
/* 	strPath : strPath is of tTools                                                            */
/* 	strRemarks : strRemarks is of tTools                                                      */  
create table tTools ( 
	lToolID int identity not null,
	lEmployeeID int not null,
	strDesignation varchar(100) not null,
	strPath varchar(500) not null,
	strRemarks varchar(500) null) ON 'PRIMARY'  

go

alter table tTools
	add constraint tTools_PK primary key clustered (lToolID)   


go

/* Create new table tMasterTaxKeys.                                                           */
/* tMasterTaxKeys : MwSt.-Schlssel Stammdaten                                                */
/* 	Es wird eine Bezeichnung und das zum MwSt.-Schlssel gehrende Passivkonto definiert.     */
/* 	lMasterTaxKeyID : lMasterTaxKeyID identifies tMasterTaxKeys                               */
/* 	lPassiveAccountID : lPassiveAccountID is of tMasterTaxKeys                                */
/* 	strDesignation : strDesignation is of tMasterTaxKeys                                      */
/* 	bActive : bActive is of tMasterTaxKeys                                                    */  
create table tMasterTaxKeys ( 
	lMasterTaxKeyID int identity not null,
	lPassiveAccountID int not null,
	strDesignation varchar(100) not null,
	bActive bit not null) ON 'PRIMARY'  

go

alter table tMasterTaxKeys
	add constraint tMasterTaxKeys_PK primary key clustered (lMasterTaxKeyID)   


go

/* Create new table tMasterFreeFields.                                                        */
/* tMasterFreeFields : Stammdaten der frei definierbaren Felder                               */
/* 	Das Feld tinUsedIn gibt an fr welche Tabelle das Feld verwendet wird (tEmployees, tContacts, tOrganisations oder tProjects) */
/* 	Das Feld tinFieldType gibt an um was fr einen Typ von Feld es sich handelt. (Textfeld, Datumsfeld oder Ja/Nein-Feld) */
/* 	lMasterFreeFieldID : lMasterFreeFieldID identifies tMasterFreeFields                      */
/* 	strDesignation : strDesignation is of tMasterFreeFields                                   */
/* 	tinUsedIn : tinUsedIn is of tMasterFreeFields                                             */
/* 	tinFieldType : tinFieldType is of tMasterFreeFields                                       */  
create table tMasterFreeFields ( 
	lMasterFreeFieldID int identity not null,
	strDesignation varchar(100) not null,
	tinUsedIn tinyint not null constraint tMasterFreeFieldstinUsedIn_Chk check (tinUsedIn between 1 and 4) ,
	tinFieldType tinyint not null constraint tMasterFreeFieldstinFieldType_Chk check (tinFieldType between 1 and 3) ) ON 'PRIMARY'  

go

alter table tMasterFreeFields
	add constraint tMasterFreeFields_PK primary key clustered (lMasterFreeFieldID)   


go

/* Create new table tMasterInvConditions.                                                     */
/* tMasterInvConditions : Stammdaten Rechnungskonditionen.                                    */
/* 	Hier knnen Rechnungskonditionen in verschiedenen Sprachen definiert werden.              */
/* 	Das Feld 'lTermOfPayment' bezieht sich auf eine Zahlungsfrist in Tagen.                   */
/* 	lMasterInvCondID : lMasterInvCondID identifies tMasterInvConditions                       */
/* 	strDesignation : strDesignation is of tMasterInvConditions                                */
/* 	lTermOfPayment : lTermOfPayment is of tMasterInvConditions                                */  
create table tMasterInvConditions ( 
	lMasterInvCondID int identity not null,
	strDesignation varchar(100) not null,
	lTermOfPayment int not null) ON 'PRIMARY'  

go

alter table tMasterInvConditions
	add constraint tMasterInvConditions_PK primary key clustered (lMasterInvCondID)   


go


/* Create new table "tMasterInvoiceState".                                                    */
/* "tMasterInvoiceState" : Table of tMasterInvoiceState                                       */
/* 	"lMasterInvoiceStateID" : lMasterInvoiceStateID identifies tMasterInvoiceState            */
/* 	"strDesignation" : strDesignation is of tMasterInvoiceState                               */  
create table tMasterInvoiceState ( 
	lMasterInvoiceStateID int identity not null,
	strDesignation varchar(100) not null)  

go

alter table tMasterInvoiceState
	add constraint tMasterInvoiceState_PK primary key (lMasterInvoiceStateID)   
go


/* Create new table tMasterCurrencies.                                                        */
/* tMasterCurrencies : Whrungs-Stammdaten                                                    */
/* 	Eine Whrung ist immer die Stammwhrung und die anderen Whrungen beziehen sich auf diese Whrung. */
/* 	Das Feld                                                                                  */
/* 	lMasterCurrencyID : lMasterCurrencyID identifies tMasterCurrencies                        */
/* 	strCurrency : strCurrency is of tMasterCurrencies                                         */
/* 	decFactor : decFactor is of tMasterCurrencies                                             */
/* 	dtValidAt : dtValidAt is of tMasterCurrencies                                             */
/*	strDebtorAccountNo : strDebtorAccountNo is of tMasterCurrencies				  */ 
create table tMasterCurrencies ( 
	lMasterCurrencyID int identity not null,
	strCurrency varchar(10) not null,
	decFactor decimal(9,4) not null,
	dtValidAt smalldatetime not null, 
	strDebtorAccountNo varchar(100) null) ON 'PRIMARY'  

go

alter table tMasterCurrencies
	add constraint tMasterCurrencies_PK primary key clustered (lMasterCurrencyID)   


go

/* Create new table tMasterPubHolidays.                                                       */
/* tMasterPubHolidays : In dieser Tabelle werden die Feiertage abgespeichert                  */
/* 	Wenn die Option 'jedes Jahr gltig' gesetzt wird, so muss dieser Feiertag nicht jedes Jahr neu erfasst werden, sondern wird immer bei der Saldoberechnung bercksichtigt.  */
/* 	Wieviel ein Feiertag angerechnet wird, kann ber das Feld decDuration angegeben werden, dieses Feld kann zwischen 0 und 1 liegen. Es wird dieses Feld Mal die Arbeitszeit eines Tages gerechnet. (Somit kann die Wochenarbeitszeit angepasst werden und der Feiertag wird immer noch zu diesem Anteil gerechnet) */
/* 	lMasterPubHolidayID : lMasterPubHolidayID identifies tMasterPubHolidays                   */
/* 	strDesignation : strDesignation is of tMasterPubHolidays                                  */
/* 	dtDate : dtDate is of tMasterPubHolidays                                                  */
/* 	decDuration : decDuration is of tMasterPubHolidays                                        */
/* 	bValidEveryYear : bValidEveryYear is of tMasterPubHolidays                                */  
create table tMasterPubHolidays ( 
	lMasterPubHolidayID int identity not null,
	strDesignation varchar(100) not null,
	dtDate smalldatetime not null,
	decDuration decimal(9,3) not null,
	bValidEveryYear bit not null) ON 'PRIMARY'  

go

alter table tMasterPubHolidays
	add constraint tMasterPubHolidays_PK primary key clustered (lMasterPubHolidayID)   


go

/* Create new table tMasterAccounts.                                                          */
/* tMasterAccounts : Kontoplan                                                                */
/* 	Hier werden alle Konti erfasst                                                            */
/* 	Das Feld tinType gibt an, um was fr ein Konto es sich handelt (Ertrags, Aufwands, Aktiv oder Passivkonto) */
/* 	lMasterAccountID : lMasterAccountID identifies tMasterAccounts                            */
/* 	strAccountNo : strAccountNo is of tMasterAccounts                                             */
/* 	strDesignation : strDesignation is of tMasterAccounts                                     */
/* 	tinType : tinType is of tMasterAccounts                                                   */  
create table tMasterAccounts ( 
	lMasterAccountID int identity not null,
	strAccountNo varchar(13) not null,
	strDesignation varchar(100) not null,
	tinType tinyint not null constraint tMasterAccountstinType_Chk check (tinType between 1 and 4) ) ON 'PRIMARY'  

go

alter table tMasterAccounts
	add constraint tMasterAccounts_PK primary key clustered (lMasterAccountID)   


go

/* Create new table tMasterMaterials.                                                   */
/* tMasterMaterials : Material Stammdaten                                               */
/* 	zum Beispiel fr Produkte oder Verbrauchsmaterial                               */
/* 	lMasterMaterialID : lMasterMaterialID identifies tMasterMaterials               */
/* 	lIncomeAccountID : lIncomeAccountID is of tMasterMaterials                      */
/* 	lTaxKeyID : lTaxKeyID is of tMasterMaterials                                    */
/* 	lCurrencyID : lCurrencyID is of tMasterMaterials                         	*/
/* 	strDesignation : strDesignation is of tMasterMaterials                          */
/* 	decInternallyCosts : decInternallyCosts is of tMasterMaterials                  */
/* 	decExternallyCosts : decExternallyCosts is of tMasterMaterials                  */  
/* 	bActive : bActive is of tMasterMaterials                                        */  
create table tMasterMaterials ( 
	lMasterMaterialID int identity not null,
	lIncomeAccountID int not null,
	lTaxKeyID int null,
	lCurrencyID int not null,
	strDesignation varchar(100) not null,
	decInternallyCosts decimal(9,2) null,
	decExternallyCosts decimal(9,2) null,
	bActive bit not null) ON 'PRIMARY'  
go

alter table tMasterMaterials
	add constraint tMasterMaterials_PK primary key clustered (lMasterMaterialID)   


go

/* Create new table tMasterExpenses.                                                          		*/
/* tMasterExpenses : Spesen Stammdaten                                                        		*/
/* 	Hier wird definiert, wieviel zum Bespiel fr einen Fahrkilometer mit dem Auto intern und extern verrechnet wird. */
/* 	lMasterExpenseID : lMasterExpenseID identifies tMasterExpenses                            	*/
/* 	lIncomeAccountID : lIncomeAccountID is of tMasterExpenses                                 	*/
/* 	lTaxKeyID : lTaxKeyID is of tMasterExpenses                                               	*/
/* 	lCurrencyID : lCurrencyID is of tMasterExpenses                                           	*/
/*	lExpenseAccountID : lExpenseAccountID is of tMasterExpenses					*/
/* 	strDesignation : strDesignation is of tMasterExpenses                                     	*/
/* 	decInternallyCosts : decInternallyCosts is of tMasterExpenses                             	*/
/* 	decExternallyCosts : decExternallyCosts is of tMasterExpenses                             	*/  
/* 	bActive : bActive is of tMasterExpenses                                                   	*/  
create table tMasterExpenses ( 
	lMasterExpenseID int identity not null,
	lIncomeAccountID int not null,
	lTaxKeyID int null,
	lCurrencyID int not null,
	lExpenseAccountID int null,
	strDesignation varchar(100) not null,
	decInternallyCosts decimal(9,2) null,
	decExternallyCosts decimal(9,2) null,
	bActive bit not null, 
	bUseForInternAccounting bit not null) ON 'PRIMARY'  

go

alter table tMasterExpenses
	add constraint tMasterExpenses_PK primary key clustered (lMasterExpenseID)   


go

/* Create new table tLumpSums.                                                                */
/* tLumpSums : In dieser Tabelle werden Pauschalen zu einem Projekt abgespeichert.            */
/* 	Pauschalen knnen zum Beispiel auch Spesen sein, die pauschale abgerechnet werden.        */
/* 	Das Feld 'decTaxRate' wird verwendet um den MwSt.- Satz abzuspeichern, damit dieser nicht rckwirkend verndert wwerden kann, wenn die Pauschale verrechnet wurde. */
/* 	lLumpSumID : lLumpSumID identifies tLumpSums                                              */
/* 	lInvoiceID : lInvoiceID partly identifies tLumpSums                                       */
/* 	lProjectID : lProjectID is of tLumpSums                                                   */
/* 	lCurrencyID : lCurrencyID is of tLumpSums                                                 */
/* 	lTaxKeyID : lTaxKeyID is of tLumpSums                                                     */
/* 	lIncomeAccountID : lIncomeAccountID is of tLumpSums                                       */
/* 	decAmount : decAmount is of tLumpSums                                                     */
/* 	dtDueDate : dtDueDate is of tLumpSums                                                     */
/* 	decTaxRate : decTaxRate is of tLumpSums                                                   */
/* 	strText : strText is of tLumpSums                                                         */
/* 	strIntText : strIntText is of tLumpSums                                                   */    
/* 	strCreator : strCreator is of tLumpSums												*/
/* 	strEditor : strEditor is of tLumpSums												*/
/* 	dtCreated : dtCreated is of tLumpSums												*/
/* 	dtEdited : dtEdited is of tLumpSums													*/ 
create table tLumpSums ( 
	lLumpSumID int identity not null,
	lInvoiceID int null,
	lProjectID int not null,
	lCurrencyID int not null,
	lTaxKeyID int null,
	lIncomeAccountID int not null,
	decAmount decimal(9,2) not null,
	dtDueDate smalldatetime not null,
	decTaxRate decimal(9,2) null,
	strText varchar(500) not null,
	strIntText varchar(500) null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

go

alter table tLumpSums
	add constraint tLumpSums_PK primary key clustered (lLumpSumID)   

go


/* Create new table tAccPayments.                                                                	*/
/* tAccPayments : In dieser Tabelle werden Akontoeintrge zu einem Projekt abgespeichert.        	*/
/*													*/
/* 	lAccPaymentID : lAccPaymentID identifies tAccPayments                                           */
/*	lAccPaymInvID : lAccPaymInvID is of tAccPayments  						*/	
/* 	lInvoiceID : lInvoiceID is of  tAccPayments                                       		*/
/* 	lProjectID : lProjectID is of tAccPayments                                                   	*/
/* 	lCurrencyID : lCurrencyID is of tAccPayments                                                 	*/
/* 	lTaxKeyID : lTaxKeyID is of tAccPayments                                                     	*/
/* 	lIncomeAccountID : lIncomeAccountID is of tAccPayments                                       	*/
/* 	decAmount : decAmount is of tAccPayments                                                     	*/
/* 	dtDueDate : dtDueDate is of tAccPayments                                                     	*/
/* 	decTaxRate : decTaxRate is of tAccPayments                                                   	*/
/* 	strText : strText is of tAccPayments                                                         	*/  
/* 	strIntText : strIntText is of tAccPayments                                                     	*/  
/* 	strCreator : strCreator is of tAccPayments												*/
/* 	strEditor : strEditor is of tAccPayments												*/
/* 	dtCreated : dtCreated is of tAccPayments												*/
/* 	dtEdited : dtEdited is of tAccPayments													*/ 
create table tAccPayments ( 
	lAccPaymentID int identity not null,
	lAccPaymInvID int null,
	lInvoiceID int null,
	lProjectID int not null,
	lCurrencyID int not null,
	lTaxKeyID int null,
	lIncomeAccountID int not null,
	decAmount decimal(9,2) not null,
	dtDueDate smalldatetime not null,
	decTaxRate decimal(9,2) null,
	strText varchar(500) not null,
	strIntText varchar(500) null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

GO


/* PRIMARY KEY Constraint for table tAccPayments */
alter table tAccPayments
	add constraint tAccPayments_PK primary key clustered (lAccPaymentID)   

GO


/* Create new table tFeeTasks.                                                                */
/* tFeeTasks : Tasks fr die Honorare  (z.Bsp. Verwaltungsratshonorare)                       */
/* 	Das Interval wird in Monaten abgespeichert.                                               */
/* 	Diese Tabelle definiert nur wann welche Honorare fllig sind.                             */
/* 	lFeeTaskID : lFeeTaskID identifies tFeeTasks                                              */
/* 	lProjectID : lProjectID is of tFeeTasks                                                   */
/* 	lCurrencyID : lCurrencyID is of tFeeTasks                                                 */
/* 	lTaxKeyID : lTaxKeyID is of tFeeTasks                                                     */
/* 	lIncomeAccountID : lIncomeAccountID is of tFeeTasks                                       */
/* 	bActive : bActive is of tFeeTasks                                                         */
/* 	decAmount : decAmount is of tFeeTasks                                                     */
/* 	dtDueDate : dtDueDate is of tFeeTasks                                                     */
/* 	lInterval : lInterval is of tFeeTasks                                                     */
/* 	strText : strText is of tFeeTasks                                                         */  
/* 	strIntText : strIntText is of tFeeTasks                                                   */
/* 	strCreator : strCreator is of tFeeTasks												*/
/* 	strEditor : strEditor is of tFeeTasks												*/
/* 	dtCreated : dtCreated is of tFeeTasks												*/
/* 	dtEdited : dtEdited is of tFeeTasks													*/ 
create table tFeeTasks ( 
	lFeeTaskID int identity not null,
	lProjectID int not null,
	lCurrencyID int not null,
	lTaxKeyID int null,
	lIncomeAccountID int not null,
	bActive bit not null,
	decAmount decimal(9,2) not null,
	dtDueDate datetime not null,
	lInterval int not null,
	strText varchar(500) not null,
	strIntText varchar(500) null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

go

alter table tFeeTasks
	add constraint tFeeTasks_PK primary key clustered (lFeeTaskID)   


go

/* Create new table tInvoices.                                                                */
/* tInvoices : Fakturas, die abgespeichert wurden.                                            */
/* 	Es wird die Fakturierungskondition (Anzahl Tage bis zur Zahlung) aus den Stammdaten, die Whrung und Sprache in der die Rechnung erstellt wurde abgespeichert. Der Rechnungstext, die Anschrift, und die Bemerkungen mssen auch abgespeichert werden. */
/* 	Das Feld 'tinReportStyle' gibt an wie der Report gegliedert war.                          */
/* 	Die Bit-Felder sind da um anzugeben, ob verrechnete Aufwnde und effektive angezeigt werden. (siehe Prototyp Fakturierung) */
/* 	lInvoiceID : lInvoiceID identifies tInvoices                                              */
/* 	lInvoiceNo : lInvoiceNo is of tInvoices                                                   */
/* 	lCurrencyID : lCurrencyID is of tInvoices                                                 */
/* 	lLanguageID : lLanguageID is of tInvoices                                                 */
/* 	lCreatorID : lCreatorID is of tInvoices                                                   */
/* 	lProjectID : lProjectID is of tInvoices							  */
/*	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID is of tInvoices			  */
/*	lMasterInvoiceStateID : lMasterInvoiceStateID is of tInvoices				  */
/* 	dtPerDate : dtPerDate is of tInvoices                                             	  */
/* 	dtInvoiceDate : dtInvoiceDate is of tInvoices                                             */
/* 	decAmount : decAmount is of tInvoices                                                     */
/* 	strAddress : strAddress is of tInvoices                                                   */
/* 	strInvoiceText : strInvoiceText is of tInvoices                                           */
/* 	strInvoiceRemarks : strInvoiceRemakrs is of tInvoices                                     */
/* 	dtLastDunning : dtLastDunning is of tInvoices                                             */
/* 	lNoOfDunnings : lNoOfDunnings is of tInvoices                                             */
/* 	strCondition : strCondition is of tInvoices                                               */
/* 	lTermOfPayment : lTermOfPayment is of tInvoices                                           */
/* 	lDocumentNo : lDocumentNo is of tInvoices                                                 */
/*	decCurFactor : decCurFactor is of tInvoices								*/
/*	strTimeServices : strTimeServices is of tInvoices						*/
/*	strExpServices : strExpServices is of tInvoices							*/
/*	strMatServices : strMatServices is of tInvoices							*/
/*	strLumpSums : strLumpSums is of tInvoices								*/
/*	strFees : strFees is of tInvoices										*/
/*	strProjectLabel : strProjectLabel is of tInvoices						*/
/*	strAccPayments : strAccPayments is of tInvoices							*/
/*	strTaxRate : strTaxRate is of tInvoices									*/
/*	bBeforev300 : bBeforev300 is of tInvoices								*/
/*  strProjectText : strProjectText is of tInvoices							*/
/*  strPeriod : strPeriod is of tInvoices									*/
create table tInvoices ( 
	lInvoiceID int identity not null,
	lInvoiceNo int not null,
	lCurrencyID int not null,
	lLanguageID int not null,
	lCreatorID int not null,
	lProjectID int not null,
	lInvoiceRptDefinitionID int not null,
	lMasterInvoiceStateID int null,
	dtPerDate smalldatetime not null,	
	dtInvoiceDate smalldatetime not null,
	decAmount decimal(9,2) not null,
	strAddress varchar(250) not null,
	strInvoiceText varchar(500) null,
	strInvoiceRemarks varchar(500) null,
	dtLastDunning smalldatetime null,
	lNoOfDunnings int null,
	strCondition varchar(100) not null,
	lTermOfPayment int not null,
	lDocumentNo int null,
	decCurFactor decimal(9,4) null,
	strTimeServices varchar(100) null,
	strExpServices varchar(100) null,
	strMatServices varchar(100) null,
	strLumpSums varchar(100) null,
	strFees varchar(100) null,
	strProjectLabel varchar(100) null,
	strAccPayments varchar(100) null,
	strTaxRate varchar(100) null, 
	bBeforev300 bit null,
	strProjectText ntext null,
	strPeriod varchar(150) null) ON 'PRIMARY'   

go

alter table tInvoices
	add constraint tInvoices_PK primary key clustered (lInvoiceID)   
go

/* Create new table tInvCurFactors							*/
/* tInvCurFactors : Table of tInvCurFactors                                       	*/
/* 	lInvCurFactorID : lInvCurFactorID identifies tInvCurFactors                     */
/* 	lInvoiceID : lInvoiceID identifies tInvCurFactors                               */
/* 	lCurrencyID : lCurrencyID identifies tInvCurFactors                             */
/* 	decFactor : decFactor is of tInvCurFactors                                     	*/
create table tInvCurFactors ( 
	lInvCurFactorID int identity not null,
	lInvoiceID int not null,
	lCurrencyID int not null,
	decFactor decimal(9,4) not null)  
go

alter table tInvCurFactors
	add constraint tInvCurFactors_PK primary key (lInvCurFactorID)
go

/* Create new table tProjectTeam.                                                             */
/* tProjectTeam : Die Mitglieder eines Projektes werden abgebildet                            */
/* 	Hat Einfluss auf die Berechtigung und Sichtbarkeit eines Projektes                        */
/* 	lProjectTeamID : lProjectTeamID identifies tProjectTeam                                   */
/* 	lEmployeeID : lEmployeeID is of tProjectTeam                                              */
/* 	lProjectID : lProjectID is of tProjectTeam                                                */
/* 	bProjectLeader : bProjectLeader is of tProjectTeam                                        */ 
/*	decHourlyRate : decHourlyRate is of tProjectTeam					*/ 
create table tProjectTeam ( 
	lProjectTeamID int identity not null,
	lEmployeeID int not null,
	lProjectID int not null,
	bProjectLeader bit not null, 
	decHourlyRate decimal(9,2) null) ON 'PRIMARY'  

go

alter table tProjectTeam
	add constraint tProjectTeam_PK primary key clustered (lProjectTeamID)   


go

/* Create new table tMasterActivities.                                                        		*/
/* tMasterActivities : Ttigkeits -Stammdaten                                                 		*/
/* 	hier werden alle Stammdaten definiert, die verwendet werden knnen.                       	*/
/* 	Es wird ein Konto- und ein MwSt.-Konto definiert, sowie eine Bezeichnung und ein Stundensatz 	*/
/* 	lMasterActivityID : lMasterActivityID identifies tMasterActivities                        	*/
/* 	lIncomeAccountID : lIncomeAccountID is of tMasterActivities                               	*/
/* 	lTaxKeyID : lTaxKeyID is of tMasterActivities                                             	*/
/* 	lCurrencyID : lCurrencyID is of tMasterActivities                                             	*/
/* 	strDesignation : strDesignation is of tMasterActivities                                   	*/
/* 	decHourlyRate : decHourlyRate is of tMasterActivities                                     	*/  
/*	bUseEmpHRate : bUseEmpHRate is of tMasterActivities						*/
/* 	decHourlyRate1 : decHourlyRate1 is of tMasterActivities                                     	*/  
/* 	decHourlyRate2 : decHourlyRate2 is of tMasterActivities                                     	*/  
/* 	decHourlyRate3 : decHourlyRate3 is of tMasterActivities                                     	*/  
/* 	decHourlyRate4 : decHourlyRate4 is of tMasterActivities                                     	*/  
/* 	decHourlyRate5 : decHourlyRate5 is of tMasterActivities                                     	*/  
/* 	decHourlyRate6 : decHourlyRate6 is of tMasterActivities                                     	*/  
/* 	decHourlyRate7 : decHourlyRate7 is of tMasterActivities                                     	*/  
/* 	decHourlyRate8 : decHourlyRate8 is of tMasterActivities                                     	*/  
/* 	decHourlyRate9 : decHourlyRate9 is of tMasterActivities                                     	*/  
/* 	decHourlyRate10 : decHourlyRate10 is of tMasterActivities                                     	*/  
/* 	decHourlyRate11 : decHourlyRate11 is of tMasterActivities                                     	*/  
/* 	decHourlyRate12 : decHourlyRate12 is of tMasterActivities                                     	*/
/* 	decHourlyRate13 : decHourlyRate13 is of tMasterActivities                                     	*/
/* 	decHourlyRate14 : decHourlyRate14 is of tMasterActivities                                     	*/
/* 	decHourlyRate15 : decHourlyRate15 is of tMasterActivities                                     	*/
/* 	decHourlyRate16 : decHourlyRate16 is of tMasterActivities                                     	*/
/* 	decHourlyRate17 : decHourlyRate17 is of tMasterActivities                                     	*/
/* 	decHourlyRate18 : decHourlyRate18 is of tMasterActivities                                     	*/
/* 	decHourlyRate19 : decHourlyRate19 is of tMasterActivities                                     	*/
/* 	decHourlyRate20 : decHourlyRate20 is of tMasterActivities                                     	*/
/* 	decHourlyRate21 : decHourlyRate21 is of tMasterActivities                                     	*/
/* 	decHourlyRate22 : decHourlyRate22 is of tMasterActivities                                     	*/
/* 	decHourlyRate23 : decHourlyRate23 is of tMasterActivities                                     	*/
/* 	decHourlyRate24 : decHourlyRate24 is of tMasterActivities                                     	*/
/* 	bActive : bActive is of tMasterActivities                                                   	*/  
/*	lSortIndex : lSortIndex is of tMasterActivities							*/
create table tMasterActivities ( 
	lMasterActivityID int identity not null,
	lIncomeAccountID int not null,
	lTaxKeyID int null,
	lCurrencyID int not null,
	strDesignation varchar(100) not null,
	decHourlyRate decimal(9,2) not null,
	bUseEmpHRate bit not null,
	decHourlyRate1 decimal(9,2) null,
	decHourlyRate2 decimal(9,2) null,
	decHourlyRate3 decimal(9,2) null,
	decHourlyRate4 decimal(9,2) null,
	decHourlyRate5 decimal(9,2) null,
	decHourlyRate6 decimal(9,2) null,
	decHourlyRate7 decimal(9,2) null,
	decHourlyRate8 decimal(9,2) null,
	decHourlyRate9 decimal(9,2) null,
	decHourlyRate10 decimal(9,2) null,
	decHourlyRate11 decimal(9,2) null,
	decHourlyRate12 decimal(9,2) null,
	decHourlyRate13 decimal(9,2) null,
	decHourlyRate14 decimal(9,2) null,
	decHourlyRate15 decimal(9,2) null,
	decHourlyRate16 decimal(9,2) null,
	decHourlyRate17 decimal(9,2) null,
	decHourlyRate18 decimal(9,2) null,
	decHourlyRate19 decimal(9,2) null,
	decHourlyRate20 decimal(9,2) null,
	decHourlyRate21 decimal(9,2) null,
	decHourlyRate22 decimal(9,2) null,
	decHourlyRate23 decimal(9,2) null,
	decHourlyRate24 decimal(9,2) null,
	bActive bit not null,
	lSortIndex int null) ON 'PRIMARY'  

go

alter table tMasterActivities
	add constraint tMasterActivities_PK primary key clustered (lMasterActivityID)   


go

/* Create new table tActivities.                                                              				*/
/* tActivities : Ttigkeiten aus den Stammdaten, die den Projekten zugeordnet sind            				*/
/* 	lActivityID : lActivityID identifies tActivities                                          			*/
/* 	lMasterActivityID : lMasterActivityID is of tActivities                                   			*/
/* 	lIncomeAccountID : lIncomeAccountID is of tActivities                                     			*/
/* 	lTaxKeyID : lTaxKeyID is of tActivities                                                   			*/
/* 	decHourlyRate : decHourlyRate is of tActivities                                           			*/
/* 	lTimeBudget : lTimeBudget is of tActivities                                               			*/
/* 	bForInvoice : bForInvoice is of tActivities                                               			*/
/* 	bProductive : bProductive is of tActivities                                               			*/  
/*	bUseEmpHRate : bUseEmpHRate is of tActivities									*/
/* 	decHourlyRate1 : decHourlyRate1 is of tMasterActivities                                     			*/  
/* 	decHourlyRate2 : decHourlyRate2 is of tMasterActivities                                     			*/  
/* 	decHourlyRate3 : decHourlyRate3 is of tMasterActivities                                     			*/  
/* 	decHourlyRate4 : decHourlyRate4 is of tMasterActivities                                     			*/  
/* 	decHourlyRate5 : decHourlyRate5 is of tMasterActivities                                     			*/  
/* 	decHourlyRate6 : decHourlyRate6 is of tMasterActivities                                     			*/  
/* 	decHourlyRate7 : decHourlyRate7 is of tMasterActivities                                     			*/  
/* 	decHourlyRate8 : decHourlyRate8 is of tMasterActivities                                     			*/  
/* 	decHourlyRate9 : decHourlyRate9 is of tMasterActivities                                     			*/  
/* 	decHourlyRate10 : decHourlyRate10 is of tMasterActivities                                     			*/  
/* 	decHourlyRate11 : decHourlyRate11 is of tMasterActivities                                     			*/  
/* 	decHourlyRate12 : decHourlyRate12 is of tMasterActivities                                     			*/  
/* 	lExpectedTimeDifference : lExpectedTimeDifference is of tActivities                                            	*/
/*	strControllingRemarks : strControllingRemarks is of tActivites							*/
/* 	decHourlyRate13 : decHourlyRate13 is of tMasterActivities                                     			*/  
/* 	decHourlyRate14 : decHourlyRate14 is of tMasterActivities                                     			*/  
/* 	decHourlyRate15 : decHourlyRate15 is of tMasterActivities                                     			*/  
/* 	decHourlyRate16 : decHourlyRate16 is of tMasterActivities                                     			*/  
/* 	decHourlyRate17 : decHourlyRate17 is of tMasterActivities                                     			*/  
/* 	decHourlyRate18 : decHourlyRate18 is of tMasterActivities                                     			*/  
/* 	decHourlyRate19 : decHourlyRate19 is of tMasterActivities                                     			*/  
/* 	decHourlyRate20 : decHourlyRate20 is of tMasterActivities                                     			*/  
/* 	decHourlyRate21 : decHourlyRate21 is of tMasterActivities                                     			*/  
/* 	decHourlyRate22 : decHourlyRate22 is of tMasterActivities                                     			*/  
/* 	decHourlyRate23 : decHourlyRate23 is of tMasterActivities                                     			*/  
/* 	decHourlyRate24 : decHourlyRate24 is of tMasterActivities                                     			*/  
create table tActivities ( 
	lActivityID int identity not null,
	lMasterActivityID int not null,
	lIncomeAccountID int not null,
	lTaxKeyID int null,
	decHourlyRate decimal(9,2) not null,
	lTimeBudget int null,
	bForInvoice bit not null,
	bProductive bit not null,
	bUseEmpHRate bit not null,
	decHourlyRate1 decimal(9,2) null,
	decHourlyRate2 decimal(9,2) null,
	decHourlyRate3 decimal(9,2) null,
	decHourlyRate4 decimal(9,2) null,
	decHourlyRate5 decimal(9,2) null,
	decHourlyRate6 decimal(9,2) null,
	decHourlyRate7 decimal(9,2) null,
	decHourlyRate8 decimal(9,2) null,
	decHourlyRate9 decimal(9,2) null,
	decHourlyRate10 decimal(9,2) null,
	decHourlyRate11 decimal(9,2) null,
	decHourlyRate12 decimal(9,2) null,
	lExpectedTimeDifference int null, 
	strControllingRemarks varchar(500),
	decHourlyRate13 decimal(9,2) null,
	decHourlyRate14 decimal(9,2) null,
	decHourlyRate15 decimal(9,2) null,
	decHourlyRate16 decimal(9,2) null,
	decHourlyRate17 decimal(9,2) null,
	decHourlyRate18 decimal(9,2) null,
	decHourlyRate19 decimal(9,2) null,
	decHourlyRate20 decimal(9,2) null,
	decHourlyRate21 decimal(9,2) null,
	decHourlyRate22 decimal(9,2) null,
	decHourlyRate23 decimal(9,2) null,
	decHourlyRate24 decimal(9,2) null) ON 'PRIMARY'  

go

alter table tActivities
	add constraint tActivities_PK primary key clustered (lActivityID)   


go

/* Create new table tStructures.                                                              */
/* tStructures : In dieser Tabelle wird die Struktur der Projekte abgelegt, mit Gruppierungen und Ttigkeiten. */
/* 	Die Projekt ID wird zu jedem Eintrag abgelegt, da dies das lesen vereinfacht.             */
/* 	Die ParentID eines Projektes zeigt auf sich selbst.                                       */
/* 	Es werden auch die Ttigkeits und Projektbezeichung in diesem Projekt abgelegt            */
/* 	lStructureID : lStructureID identifies tStructures                                        */
/* 	lParentID : lParentID is of tStructures                                                   */
/* 	lProjectID : lProjectID is of tStructures                                                 */
/* 	lActivityID : lActivityID partly identifies tStructures                                   */
/* 	strDesignation : strDesignation is of tStructures                                         */
/* 	bActive : bActive is of tStructures                                         		  */
/* 	lSortIndex : lSortIndex is of tStructures                                         	  */
/* 	decBudgetInc : decBudgetInc is of tStructures                                         	  */  
/* 	decBudgetExp : decBudgetExp is of tStructures						  */
create table tStructures ( 
	lStructureID int not null,
	lParentID int not null,
	lProjectID int not null,
	lActivityID int null,
	strDesignation varchar(100) not null,
	bActive bit not null,
	lSortIndex int null,
	decBudgetInc decimal(9,2) null,
	decBudgetExp decimal(9,2) null) ON 'PRIMARY'  

go

alter table tStructures
	add constraint tStructures_PK primary key clustered (lStructureID)   


go

/* Create new table tExpenseServices.                                                         */
/* tExpenseServices : Die Spesenaufwnde werden in dieser Tabelle gespeichert                 */
/* 	lExpenseServiceID : lExpenseServiceID identifies tExpenseServices                         */
/* 	lInvoiceID : lInvoiceID partly identifies tExpenseServices                                */
/* 	lStructureID : lStructureID is of tExpenseServices                                        */
/* 	lEmployeeID : lEmployeeID is of tExpenseServices                                          */
/* 	lMasterExpenseID : lMasterExpenseID is of tExpenseServices                                */
/* 	lCurrencyID : lCurrencyID is of tExpenseServices                                          */
/* 	lTaxKeyID : lTaxKeyID is of tExpenseServices                                              */
/* 	lIncomeAccountID : lIncomeAccountID is of tExpenseServices                                */
/* 	dtDate : dtDate is of tExpenseServices                                                    */
/* 	decQuantity : decQuantity is of tExpenseServices                                          */
/* 	decInternallyCosts : decInternallyCosts is of tExpenseServices                            */
/* 	decExternallyCosts : decExternallyCosts is of tExpenseServices                            */
/* 	decAmountInvoiced : decAmountInvoiced is of tExpenseServices                              */
/* 	decTaxRate : decTaxRate is of tExpenseServices                                            */
/* 	bForInvoice : bForInvoice is of tExpenseServices                                          */
/* 	strRemarks : strRemarks is of tExpenseServices                                            */  
/* 	strIntRemarks : strIntRemarks is of tExpenseServices                                      */  
/*	dtCleared : dtClearde is of tExpenseServices						  */
/* 	strCreator : strCreator is of tExpenseServices												*/
/* 	strEditor : strEditor is of tExpenseServices												*/
/* 	dtCreated : dtCreated is of tExpenseServices												*/
/* 	dtEdited : dtEdited is of tExpenseServices													*/
create table tExpenseServices ( 
	lExpenseServiceID int identity not null,
	lInvoiceID int null,
	lStructureID int not null,
	lEmployeeID int not null,
	lMasterExpenseID int not null,
	lCurrencyID int not null,
	lTaxKeyID int null,
	lIncomeAccountID int not null,
	dtDate smalldatetime not null,
	decQuantity decimal(9,2) not null,
	decInternallyCosts decimal(9,2) null,
	decExternallyCosts decimal(9,2) null,
	decAmountInvoiced decimal(9,2) null,
	decTaxRate decimal(9,2) null,
	bForInvoice bit not null,
	strRemarks varchar(500) null,
	strIntRemarks varchar(500) null,
	dtCleared smalldatetime null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

go

alter table tExpenseServices
	add constraint tExpenseServices_PK primary key clustered (lExpenseServiceID)   


go

/* Create new table tMaterialServices.                                                        */
/* tMaterialServices : Die Materialaufwnde werden in dieser Tabelle gespeichert              */
/* 	lMaterialServiceID : lMaterialServiceID identifies tMaterialServices                      */
/* 	lInvoiceID : lInvoiceID partly identifies tMaterialServices                               */
/* 	lStructureID : lStructureID is of tMaterialServices                                       */
/* 	lEmployeeID : lEmployeeID is of tMaterialServices                                         */
/* 	lCurrencyID : lCurrencyID is of tMaterialServices                                         */
/* 	lMasterMaterialID : lMasterMaterialID is of tMaterialServices                             */
/* 	lIncomeAccountID : lIncomeAccountID is of tMaterialServices                               */
/* 	lTaxKeyID : lTaxKeyID is of tMaterialServices                                             */
/* 	dtDate : dtDate is of tMaterialServices                                                   */
/* 	decQuantity : decQuantity is of tMaterialServices                                         */
/* 	decInternallyCosts : decInternallyCosts is of tMaterialServices                           */
/* 	decExternallyCosts : decExternallyCosts is of tMaterialServices                           */
/* 	decAmountInvoiced : decAmountInvoiced is of tMaterialServices                             */
/* 	decTaxRate : decTaxRate is of tMaterialServices                                           */
/* 	strRemarks : strRemarks is of tMaterialServices                                           */  
/* 	strIntRemarks : strIntRemarks is of tMaterialServices                                     */
/* 	strCreator : strCreator is of tMaterialServices												*/
/* 	strEditor : strEditor is of tMaterialServices												*/
/* 	dtCreated : dtCreated is of tMaterialServices												*/
/* 	dtEdited : dtEdited is of tMaterialServices													*/ 
create table tMaterialServices ( 
	lMaterialServiceID int identity not null,
	lInvoiceID int null,
	lStructureID int not null,
	lEmployeeID int not null,
	lCurrencyID int not null,
	lMasterMaterialID int not null,
	lIncomeAccountID int not null,
	lTaxKeyID int null,
	dtDate smalldatetime not null,
	decQuantity decimal(9,2) not null,
	decInternallyCosts decimal(9,2) null,
	decExternallyCosts decimal(9,2) null,
	decAmountInvoiced decimal(9,2) null,
	decTaxRate decimal(9,2) null,
	strRemarks varchar(500) null,
	strIntRemarks varchar(500) null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

go

alter table tMaterialServices
	add constraint tMaterialServices_PK primary key clustered (lMaterialServiceID)   


go

/* Create new table tTimeServices.                                                                */
/* tTimeServices : Die Zeitaufwnde werden in dieser Tabelle gespeichert                      	  */
/* 	Die Dauer wird in Sekunden abgespeichert                                                  */
/* 	Das Datum wird in dtFrom eingegeben wenn nur die Dauer angegebe wird                      */
/* 	lTimeServiceID : lTimeServiceID identifies tTimeServices                                  */
/* 	lInvoiceID : lInvoiceID partly identifies tTimeServices                                   */
/* 	lEmployeeID : lEmployeeID is of tTimeServices                                             */
/* 	lCurrencyID : lCurrencyID is of tTimeServices                                             */
/* 	lTaxKeyID : lTaxKeyID is of tTimeServices                                                 */
/* 	lIncomeAccountID : lIncomeAccountID is of tTimeServices                                   */
/* 	lActivityID : lActivityID is of tTimeServices                                             */
/* 	dtFrom : dtFrom is of tTimeServices                                                       */
/* 	dtTo : dtTo is of tTimeServices                                                           */
/* 	lDuration : lDuration is of tTimeServices                                                 */
/* 	lDurationInvoiced : lDurationInvoiced is of tTimeServices                                 */
/* 	decHourlyRate : decHourlyRate is of tTimeServices                                         */
/* 	decTaxRate : decTaxRate is of tTimeServices                                               */
/* 	bForInvoice : bForInvoice is of tTimeServices                                             */
/* 	bProductive : bProductive is of tTimeServices                                             */
/* 	strRemarks : strRemarks is of tTimeServices                                               */
/* 	strIntRemarks : strIntRemarks is of tTimeServices                                         */  
/* 	strCreator : strCreator is of tTimeServices												*/
/* 	strEditor : strEditor is of tTimeServices												*/
/* 	dtCreated : dtCreated is of tTimeServices												*/
/* 	dtEdited : dtEdited is of tTimeServices													*/
create table tTimeServices ( 
	lTimeServiceID int identity not null,
	lInvoiceID int null,
	lEmployeeID int not null,
	lCurrencyID int not null,
	lTaxKeyID int null,
	lIncomeAccountID int not null,
	lActivityID int not null,
	dtFrom datetime not null,
	dtTo datetime null,
	lDuration int not null,
	lDurationInvoiced int not null,
	decHourlyRate decimal(9,2) not null,
	decTaxRate decimal(9,2) null,
	bForInvoice bit not null,
	bProductive bit not null,
	strRemarks varchar(5000) null,
	strIntRemarks varchar(500) null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

go

alter table tTimeServices
	add constraint tTimeServices_PK primary key clustered (lTimeServiceID)   


go

/* Create new table tOrganizations.                                                           	  */
/* tOrganizations : Hier werden die Daten der Organisationen gespeichert                          */
/* 	lOrganizationID : lOrganizationID identifies tOrganizations                               */
/* 	strDesignation : strDesignation is of tOrganizations                                      */
/* 	strAddress1 : strAddress1 is of tOrganizations                                            */
/* 	strAddress2 : strAddress2 is of tOrganizations                                            */
/* 	strZipCode : strZipCode is of tOrganizations                                              */
/* 	strResidence : strResidence is of tOrganizations                                          */
/* 	strNation : strNation is of tOrganizations                                                */
/* 	strPhone : strPhone is of tOrganizations                                                  */
/* 	strFax : strFax is of tOrganizations                                                      */
/* 	strWebPageURL : strWebPageURL is of tOrganizations                                        */
/* 	strFreeDef1 : strFreeDef1 is of tOrganizations                                            */
/* 	strFreeDef2 : strFreeDef2 is of tOrganizations                                            */
/* 	strFreeDef3 : strFreeDef3 is of tOrganizations                                            */
/* 	strFreeDef4 : strFreeDef4 is of tOrganizations                                            */
/* 	dtFreeDef1 : dtFreeDef1 is of tOrganizations                                              */
/* 	dtFreeDef2 : dtFreeDef2 is of tOrganizations                                              */
/* 	dtFreeDef3 : dtFreeDef3 is of tOrganizations                                              */
/* 	dtFreeDef4 : dtFreeDef4 is of tOrganizations                                              */
/* 	bFreeDef1 : bFreeDef1 is of tOrganizations                                                */
/* 	bFreeDef2 : bFreeDef2 is of tOrganizations                                                */
/* 	bFreeDef3 : bFreeDef3 is of tOrganizations                                                */
/* 	bFreeDef4 : bFreeDef4 is of tOrganizations                                                */
/* 	strRemarks : strRemarks is of tOrganizations                                              */  
/*	strImportID : strImportID is of tOrganizations						  */
/*	bUseForInvoiceAddress : bUseForInvoiceAddress is of tOrganizations			  */
create table tOrganizations ( 
	lOrganizationID int identity not null,
	strDesignation varchar(100) not null,
	strAddress1 varchar(50) null,
	strAddress2 varchar(50) null,
	strZipCode varchar(10) null,
	strResidence varchar(50) null,
	strNation varchar(50) null,
	strPhone varchar(50) null,
	strFax varchar(50) null,
	strWebPageURL varchar(100) null,
	strFreeDef1 varchar(100) null,
	strFreeDef2 varchar(100) null,
	strFreeDef3 varchar(100) null,
	strFreeDef4 varchar(100) null,
	dtFreeDef1 smalldatetime null,
	dtFreeDef2 smalldatetime null,
	dtFreeDef3 smalldatetime null,
	dtFreeDef4 smalldatetime null,
	bFreeDef1 bit not null,
	bFreeDef2 bit not null,
	bFreeDef3 bit not null,
	bFreeDef4 bit not null,
	strRemarks varchar(2000) null,
	strImportID varchar(200) null,
	bUseForInvoiceAddress bit not null,
    strClientNo varchar(50) null) ON 'PRIMARY'  

go

alter table tOrganizations
	add constraint tOrganisations_PK primary key clustered (lOrganizationID)   

go

/* INSERT TRIGGER um zu gewhrleisten, dass die Kundennummer
   NULL sein kann, aber eindeutig sein muss, falls definiert 
   
   Autor:	Michael Hanselmann
   Datum:	2004-11-17
*/
CREATE TRIGGER tOrganizationsins ON tOrganizations for insert
as
     declare @errorNumber int,
    	     @errorMsg varchar(255)
begin

  /* trigger for insert */
  if not (select strClientNo FROM inserted) is null
  begin
   if (select count(*) from inserted, tOrganizations
    where (tOrganizations.strClientNo = inserted.strClientNo) ) > 1
    begin
      select @errorNumber = 30002, @errorMsg = 'Die Kundennummer muss eindeutig sein'
      goto errorHandler
    end
  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO

/* UPDATE TRIGGER um zu gewhrleisten, dass die Kundennummer
   NULL sein kann, aber eindeutig sein muss, falls definiert 
   
   Autor:	Michael Hanselmann
   Datum:	2004-11-17
*/
CREATE Trigger tOrganizationsupd on tOrganizations
for update 
as
BEGIN
  declare
	@rowsAffected int,
	@nullRows int,
	@validRows int, 
	@errorNumber int,
	@errorMsg varchar(255)

  select @rowsAffected = @@rowcount

/* UPDATE Trigger von strClientNo */
if
update(strClientNo)
  begin
    if not (select strClientNo FROM inserted) is null
    begin
      if (select count(*) from inserted, tOrganizations
          where (tOrganizations.strClientNo = inserted.strClientNo) ) > 1
        begin
          select @errorNumber = 30002,
                 @errorMsg = 'Die Kundennummer muss eindeutig sein'
          goto errorHandler
        end
    end
  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO

/* Create new table tContacts.                                                                */
/* tContacts : Hier werden die Daten der Kontakte gespeichert.                                */
/* 	Ein Kontakt gehrt immer zu einer Organisation.                                           */
/* 	Ein Projekt gehrt in den meisten Fllen zu einem Kontakt (muss aber nicht) und somit auch zu einer Organisation */
/* 	lContactID : lContactID identifies tContacts                                              */
/* 	lOrganizationID : lOrganizationID is of tContacts                                         */
/* 	lTaxKeyID : lTaxKeyID is of tContacts                                                     */
/* 	strSalutation : strSalutation is of tContacts                                             */
/* 	strLastName : strLastName is of tContacts                                                 */
/* 	strFirstName : strFirstName is of tContacts                                               */
/* 	strAddress1 : strAddress1 is of tContacts                                                 */
/* 	strAddress2 : strAddress2 is of tContacts                                                 */
/* 	strZipCode : strZipCode is of tContacts                                                   */
/* 	strResidence : strResidence is of tContacts                                               */
/* 	strNation : strNation is of tContacts                                                     */
/* 	strPhone : strPhone is of tContacts                                                       */
/* 	strPhoneDirect : strPhoneDirect is of tContacts                                           */
/* 	strPhonePrivate : strPhonePrivate is of tContacts                                         */
/* 	strPhoneMobile : strPhoneMobile is of tContacts                                           */
/* 	strFax : strFax is of tContacts                                                           */
/* 	strEMailOffice : strEMailOffice is of tContacts                                           */
/* 	strEMailPrivate : strEMailPrivate is of tContacts                                         */
/* 	strWebPageURL : strWebPageURL is of tContacts                                             */
/* 	strDepartment : strDepartment is of tContacts                                             */
/* 	strCapacity : strCapacity is of tContacts                                                 */
/* 	strRemarks : strRemarks is of tContacts                                                   */
/* 	strFreeDef1 : strFreeDef1 is of tContacts                                                 */
/* 	strFreeDef2 : strFreeDef2 is of tContacts                                                 */
/* 	strFreeDef3 : strFreeDef3 is of tContacts                                                 */
/* 	strFreeDef4 : strFreeDef4 is of tContacts                                                 */
/* 	dtFreeDef1 : dtFreeDef1 is of tContacts                                                   */
/* 	dtFreeDef2 : dtFreeDef2 is of tContacts                                                   */
/* 	dtFreeDef3 : dtFreeDef3 is of tContacts                                                   */
/* 	dtFreeDef4 : dtFreeDef4 is of tContacts                                                   */
/* 	bFreeDef1 : bFreeDef1 is of tContacts                                                     */
/* 	bFreeDef2 : bFreeDef2 is of tContacts                                                     */
/* 	bFreeDef3 : bFreeDef3 is of tContacts                                                     */
/* 	bFreeDef4 : bFreeDef4 is of tContacts                                                     */
/* 	bNoTax : bNoTax is of tContacts                                                           */  
/*  	lPAccNo : lPAccNo is of tContacts							  */
/*  	strAddrNo : strAddrNo is of tContacts							  */
/*	strImportID : strImportID is of tContacts						  */
create table tContacts ( 
	lContactID int identity not null,
	lOrganizationID int not null,
	lTaxKeyID int null,
	strSalutation varchar(20) null,
	strLastName varchar(50) null,
	strFirstName varchar(50) null,
	strAddress1 varchar(50) not null,
	strAddress2 varchar(50) null,
	strZipCode varchar(10) not null,
	strResidence varchar(50) not null,
	strNation varchar(50) null,
	strPhone varchar(50) null,
	strPhoneDirect varchar(50) null,
	strPhonePrivate varchar(50) null,
	strPhoneMobile varchar(50) null,
	strFax varchar(50) null,
	strEMailOffice varchar(50) null,
	strEMailPrivate varchar(50) null,
	strWebPageURL varchar(100) null,
	strDepartment varchar(100) null,
	strCapacity varchar(100) null,
	strRemarks varchar(2000) null,
	strFreeDef1 varchar(100) null,
	strFreeDef2 varchar(100) null,
	strFreeDef3 varchar(100) null,
	strFreeDef4 varchar(100) null,
	dtFreeDef1 smalldatetime null,
	dtFreeDef2 smalldatetime null,
	dtFreeDef3 smalldatetime null,
	dtFreeDef4 smalldatetime null,
	bFreeDef1 bit not null,
	bFreeDef2 bit not null,
	bFreeDef3 bit not null,
	bFreeDef4 bit not null,
	bNoTax bit not null,
	lPAccNo int null,
	strAddrNo varchar(13) null,
        strImportID varchar(200) null) ON 'PRIMARY'

go

alter table tContacts
	add constraint tContacts_PK primary key clustered (lContactID)   


go

/* Create new table tProjects.                                                                */
/* tProjects : Die Projekteigenschaften werden in dieser Tabelle abgebildet                   */
/* 	Defaultwerte (fr dtCreation wre es GETDATE() ) mssen im Script erzeugt werden, da Visio dies zur Zeit noch nicht untersttzt */
/* 	Die Bezeichnung des Projektes wird in der Tabelle tStructure abgelegt.                    */
/* 	lProjectID : lProjectID identifies tProjects                                              */
/* 	lContactID : lContactID is of tProjects                                                   */
/* 	lTaxKeyID : lTaxKeyID is of tProjects                                                     */
/*	lBrokerID : lBrokerID is of tProjects							  */
/*	lCurrencyID : lCurrencyID is of tProjects						  */
/*	lIncomeAccountID : lIncomeAccountID is of tProjects					  */
/*	lProjectTypeID : lProjectTypeID is of tProjects						  */
/*	lCostUnitID : lCostUnitID is of tProjects						  */
/*	lInvoiceRptDefinitionID : lInvoiceRptDefinitionID is of tProjects			  */
/*	lMasterInvCondID : lMasterInvCondID is ob tProjects					  */
/* 	strProjectNo : strProjectNo is of tProjects                                               */
/* 	dtCreation : dtCreation is of tProjects                                                   */
/* 	dtOrder : dtOrder is of tProjects                                                         */
/* 	dtStart : dtStart is of tProjects                                                         */
/* 	dtEnd : dtEnd is of tProjects                                                             */
/* 	tinState : tinState is of tProjects                                                       */
/* 	bTimeServicesInvoicible : bTimeServicesInvoicible is of tProjects                         */
/* 	bExpenseServicesInvoicible : bExpenseServicesInvoicible is of tProjects                   */
/* 	bVisibleForAll : bVisibleForAll is of tProjects                                           */
/* 	strNotice1 : strNotice1 is of tProjects                                                   */
/* 	strNotice1Title : strNotice1Title is of tProjects                                         */
/* 	strNotice2 : strNotice2 is of tProjects                                                   */
/* 	strNotice2Title : strNotice2Title is of tProjects                                         */
/* 	strNotice3 : strNotice3 is of tProjects                                                   */
/* 	strNotice3Title : strNotice3Title is of tProjects                                         */
/* 	strNotice4 : strNotice4 is of tProjects                                                   */
/* 	strNotice4Title : strNotice4Title is of tProjects                                         */
/* 	bProductive : bProductive is of tProjects                                                 */
/* 	strFreeDef1 : strFreeDef1 is of tProjects                                                 */
/* 	strFreeDef2 : strFreeDef2 is of tProjects                                                 */
/* 	strFreeDef3 : strFreeDef3 is of tProjects                                                 */
/* 	strFreeDef4 : strFreeDef4 is of tProjects                                                 */
/* 	dtFreeDef1 : dtFreeDef1 is of tProjects                                                   */
/* 	dtFreeDef2 : dtFreeDef2 is of tProjects                                                   */
/* 	dtFreeDef3 : dtFreeDef3 is of tProjects                                                   */
/* 	dtFreeDef4 : dtFreeDef4 is of tProjects                                                   */
/* 	bFreeDef1 : bFreeDef1 is of tProjects                                                     */
/* 	bFreeDef2 : bFreeDef2 is of tProjects                                                     */
/* 	bFreeDef3 : bFreeDef3 is of tProjects                                                     */
/* 	bFreeDef4 : bFreeDef4 is of tProjects                                                     */
/* 	bNoTax : bNoTax is of tProjects                                                           */  
/* 	strInvoiceAddress : strInvoiceAddress is of tProjects                                     */  
/* 	decTimeBudgetInc : decTimeBudgetInc is of tProjects                                       */  
/* 	decExpBudgetInc : decExpBudgetInc is of tProjects                                         */  
/* 	decMaterialBudgetInc : decMaterialBudgetInc is of tProjects                               */  
/* 	decLumpSumBudgetInc : decLumpSumBudgetInc is of tProjects                                 */  
/*  	decFeeBudgetInc : decFeeBudgetInc is of tProjects					  */
/* 	decTimeBudgetExp : decTimeBudgetExp is of tProjects                                       */  
/* 	decExpBudgetExp : decExpBudgetExp is of tProjects                                         */  
/* 	decMaterialBudgetExp : decMaterialBudgetExp is of tProjects                               */  
/* 	decHourlyRate : decHourlyRate is of tProjects                              		  */
/* 	decHourlyRateDefault : decHourlyRateDefault is of tProjects                               */
/*	bDoNotBookToFIBU : bDoNotBookToFIBU is of tProjects					  */  
/* 	strCreator : strCreator is of tProjects												*/
/* 	strEditor : strEditor is of tProjects												*/
/* 	dtEdited : dtEdited is of tProjects													*/ 
/*  strInvoiceText : strInvoiceText is of tProjects										*/
create table tProjects ( 
	lProjectID int identity not null,
	lContactID int not null,
	lTaxKeyID int null,
	lBrokerID int null,
	lCurrencyID int not null,
	lProjectTypeID int null,
	lCostUnitID int null,
	lIncomeAccountID int null,
	lInvoiceRptDefinitionID int not null,
	lMasterInvCondID int not null,
	strProjectNo varchar(50) not null,
	dtCreation smalldatetime not null,
	dtOrder smalldatetime null,
	dtStart smalldatetime null,
	dtEnd smalldatetime null,
	tinState tinyint not null constraint tProjectstinState_Chk check (tinState between 1 and 5) ,
	bTimeServicesInvoicible bit not null,
	bExpenseServicesInvoicible bit not null,
	bVisibleForAll bit not null,
	strNotice1 ntext null,
	strNotice1Title varchar(100) null,
	strNotice2 ntext null,
	strNotice2Title varchar(100) null,
	strNotice3 ntext null,
	strNotice3Title varchar(100) null,
	strNotice4 ntext null,
	strNotice4Title varchar(100) null,
	bProductive bit not null,
	strFreeDef1 varchar(100) null,
	strFreeDef2 varchar(100) null,
	strFreeDef3 varchar(100) null,
	strFreeDef4 varchar(100) null,
	dtFreeDef1 smalldatetime null,
	dtFreeDef2 smalldatetime null,
	dtFreeDef3 smalldatetime null,
	dtFreeDef4 smalldatetime null,
	bFreeDef1 bit not null,
	bFreeDef2 bit not null,
	bFreeDef3 bit not null,
	bFreeDef4 bit not null,
	bNoTax bit not null,
	strInvoiceAddress varchar(250) null,
	decTimeBudgetInc decimal(9,2) null,
	decExpBudgetInc decimal(9,2) null,
	decMaterialBudgetInc decimal(9,2) null,
	decLumpSumBudgetInc decimal(9,2) null,
	decFeeBudgetInc decimal(9,2) null,
	decTimeBudgetExp decimal(9,2) null,
	decExpBudgetExp decimal(9,2) null,
	decMaterialBudgetExp decimal(9,2) null,
	decHourlyRate decimal(9,2) null,
	decHourlyRateDefault decimal(9,2) null,
	bDoNotBookToFIBU bit not null,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtEdited smalldatetime null,
	strInvoiceText ntext null) ON 'PRIMARY'  
go

alter table tProjects
	add constraint tProjects_PK primary key clustered (lProjectID)   

go


/* Create new table tProjectDocuments.                                                        */
/* tProjectDocuments : Table of tProjectDocuments                                             */
/* 	lProjectDocumentID : lProjectDocumentID identifies tProjectDocuments                  */
/* 	lProjectID : lProjectID is of tProjectDocuments                                           */
/* 	strFilename : strFilename is of tProjectDocuments                                           */
create table tProjectDocuments ( 
	lProjectDocumentID int identity not null,
	lProjectID int not null,
	strFilename varchar(550) not null)  

go

alter table tProjectDocuments
	add constraint tProjectDocuments_PK primary key clustered (lProjectDocumentID)   


go


/* Create new table tProjectType.                                                              */
/* tProjectType : Table of tProjectType                                                        */
/* 	lProjectTypeID : lProjectTypeID identifies tProjectType                                */
/* 	strDesignation : strDesignation is of tProjectType                                     */
create table tProjectType ( 
	lProjectTypeID int identity not null,
	strDesignation varchar(100) not null)  

go

alter table tProjectType
	add constraint tProjectType_PK primary key (lProjectTypeID)


go

/* Create new table tCostCenter.                                                              	*/
/* tCostCenter : Table of tCostCenter                                                        	*/
/* 	lCostCenterID : lCostCenterID identifies tCostCenter                                	*/
/* 	strCostCenterNo : strCostCenterNo is of tCostCenter                                	*/
/* 	strDesignation : strDesignation is of tCostCenter                                     	*/
create table tCostCenter ( 
	lCostCenterID int identity not null,
	strCostCenterNo varchar(50) not null,
	strDesignation varchar(100) not null,
	bActive bit not null)  

go

alter table tCostCenter
	add constraint tCostCenter_PK primary key (lCostCenterID)
go


/* Create new table tCostUnit.                                                              	*/
/* tCostUnit : Table of tCostUnit                                                        	*/
/* 	lCostUnitID : lCostUnitID identifies tCostUnit                                	*/
/* 	strCostUnitNo : strCostUnitNo is of tCostUnit                                		*/
/* 	strDesignation : strDesignation is of tCostUnit                                     	*/
create table tCostUnit ( 
	lCostUnitID int identity not null,
	strCostUnitNo varchar(50) not null,
	strDesignation varchar(100) not null,
	bActive bit not null)  

go

alter table tCostUnit
	add constraint tCostUnit_PK primary key (lCostUnitID)
go


/* Create new table tEmployees.                                                               */
/* tEmployees : Die Mitarbeiterdaten werden in dieser Tabelle gespeichert.                    */
/* 	Die Mitarbeiter sind zugleich Benutzer des Systems.                                       */
/* 	Es knnen nur soviele Mitarbeiter definiert werden, wie dies durch den Lizenzierungsschlssel definiert wurde. */
/* 	Die Berechtigungen werden in einem String abgespeichert.                                  */
/* 	String= '0102' knnte zum Beispiel bedeuten:                                              */
/* 	                 0: kein Administrator                                                    */
/* 	                 1: Lesezugriff auf Projekte                                              */
/* 	                 0: Kein Zugriff auf Mitarbeiter                                          */
/* 	                 2: Vollzugriff auf Projekte                                              */
/* 	lEmployeeID : lEmployeeID identifies tEmployees                                           */
/* 	lAuthorisationGroupID : lAuthorisationGroupID is of tEmployees                            */
/* 	lScaleID : lScaleID is of tEmployees                                                	  */
/* 	lDepartmentID : lDepartmentID is of tEmployees                                            */
/* 	lLanguageID : lLanguageID is of tEmployees                                                */
/*	lCostCenterID : lCostCenterID is of tEmployees						  */
/* 	lPersonalNo : lPersonalNo is of tEmployees                                                */
/* 	strLogin : strLogin is of tEmployees                                                      */
/* 	strPwd : strPwd is of tEmployees                                                          */
/* 	strLastName : strLastName is of tEmployees                                                */
/* 	strFirstName : strFirstName is of tEmployees                                              */
/* 	dtEntryDate : dtEntryDate is of tEmployees                                                */
/* 	dtExitDate : dtExitDate is of tEmployees                                                  */
/* 	strPhoneInternal : strPhoneInternal is of tEmployees                                      */
/* 	strPhoneDirect : strPhoneDirect is of tEmployees                                          */
/* 	strPhonePrivate : strPhonePrivate is of tEmployees                                        */
/* 	strPhoneMobile : strPhoneMobile is of tEmployees                                          */
/* 	strEMailOffice : strEMailOffice is of tEmployees                                          */
/* 	strEMailPrivate : strEMailPrivate is of tEmployees                                        */
/* 	strAddress1 : strAddress1 is of tEmployees                                                */
/* 	strAddress2 : strAddress2 is of tEmployees                                                */
/* 	strZipCode : strZipCode is of tEmployees                                                  */
/* 	strResidence : strResidence is of tEmployees                                              */
/* 	strNation : strNation is of tEmployees                                                    */
/* 	strNativePlace : strNativePlace is of tEmployees                                          */
/* 	dtBirthdate : dtBirthdate is of tEmployees                                                */
/* 	strOldAgeInsuranceNo : strOldAgeInsuranceNo is of tEmployees                              */
/* 	decExternallyHourlyRate : decExternallyHourlyRate is of tEmployees                        */
/* 	bUseHourlyRateAlways : bUseHourlyRateAlways is of tEmployees                              */
/* 	strRights : strRights is of tEmployees                                                    */
/* 	strRemarks : strRemarks is of tEmployees                                                  */
/* 	bConsolidateTime : bConsolidateTime is of tEmployees                                      */
/* 	tinPrefWorkMode : tinPrefWorkMode is of tEmployees                                        */
/* 	strFreeDef1 : strFreeDef1 is of tEmployees                                                */
/* 	strFreeDef2 : strFreeDef2 is of tEmployees                                                */
/* 	strFreeDef3 : strFreeDef3 is of tEmployees                                                */
/* 	strFreeDef4 : strFreeDef4 is of tEmployees                                                */
/* 	dtFreeDef1 : dtFreeDef1 is of tEmployees                                                  */
/* 	dtFreeDef2 : dtFreeDef2 is of tEmployees                                                  */
/* 	dtFreeDef3 : dtFreeDef3 is of tEmployees                                                  */
/* 	dtFreeDef4 : dtFreeDef4 is of tEmployees                                                  */
/* 	bFreeDef1 : bFreeDef1 is of tEmployees                                                    */
/* 	bFreeDef2 : bFreeDef2 is of tEmployees                                                    */
/* 	bFreeDef3 : bFreeDef3 is of tEmployees                                                    */
/* 	bFreeDef4 : bFreeDef4 is of tEmployees                                                    */
/* 	bFastLogin : bFastLogin is of tEmployees                                                  */
/* 	bUseRounding : bUseRounding is of tEmployees                                              */  
/* 	strSyncFolder : strSyncFolder is of tEmployees                                            */
/*	bLoggedIn : bLoggedIn is of tEmployees							  */
/*	lLastActivitiesCount: lLastActivitiesCount is of tEmployees				  */
/*	bLastActivitiesAutoRefresh : bLastActivitiesAutoRefresh is of tEmployees	  	  */
/*	bShowProjectNo : bShowProjectNo is of tEmployees					  */
/*	bExpandTreeStructure : bExpandTreeStructure is of tEmployees				  */
/* 	strCreator : strCreator is of tEmployees												*/
/* 	strEditor : strEditor is of tEmployees												*/
/* 	dtCreated : dtCreated is of tEmployees												*/
/* 	dtEdited : dtEdited is of tEmployees													*/ 
create table tEmployees ( 
	lEmployeeID int identity not null,
	lAuthorisationGroupID int null,
	lScaleID int null,
	lDepartmentID int null,
	lLanguageID int null,
	lCostCenterID int null,
	lPersonalNo int not null,
	strLogin varchar(50) not null,
	strPwd varchar(50) not null,
	strLastName varchar(50) not null,
	strFirstName varchar(50) not null,
	dtEntryDate smalldatetime not null,
	dtExitDate smalldatetime null,
	strPhoneInternal varchar(10) null,
	strPhoneDirect varchar(50) null,
	strPhonePrivate varchar(50) null,
	strPhoneMobile varchar(50) null,
	strEMailOffice varchar(50) null,
	strEMailPrivate varchar(50) null,
	strAddress1 varchar(50) null,
	strAddress2 varchar(50) null,
	strZipCode varchar(10) null,
	strResidence varchar(50) null,
	strNation varchar(50) null,
	strNativePlace varchar(50) null,
	dtBirthdate smalldatetime null,
	strOldAgeInsuranceNo varchar(20) null,
	decExternallyHourlyRate decimal(9,2) not null,
	bUseHourlyRateAlways bit not null,
	strRights varchar(100) not null,
	strRemarks varchar(500) null,
	bConsolidateTime bit not null,
	tinPrefWorkMode tinyint not null,
	strFreeDef1 varchar(100) null,
	strFreeDef2 varchar(100) null,
	strFreeDef3 varchar(100) null,
	strFreeDef4 varchar(100) null,
	dtFreeDef1 smalldatetime null,
	dtFreeDef2 smalldatetime null,
	dtFreeDef3 smalldatetime null,
	dtFreeDef4 smalldatetime null,
	bFreeDef1 bit not null,
	bFreeDef2 bit not null,
	bFreeDef3 bit not null,
	bFreeDef4 bit not null,
	bFastLogin bit not null, 
	bUseRounding bit not null,
	strSyncFolder varchar(500) null,
	bLoggedIn bit not null default 0, 
	lLastActivitiesCount int not null default 10,
    bLastActivitiesAutoRefresh bit not null default 1,
	bShowProjectNo bit not null default 0, 
	bExpandTreeStructure bit not null default 1,
	strCreator varchar(50) null,
	strEditor varchar(50) null,
	dtCreated smalldatetime null,
	dtEdited smalldatetime null) ON 'PRIMARY'  

GO

alter table tEmployees
	add constraint tEmployees_PK primary key clustered (lEmployeeID)   


go


/* Create new table tContactCategories.                                                       */
/* tContactCategories : Table of tContactCategories                                           */
/* 	lContactCategoryID : lContactCategoryID identifies tContactCategories                     */
/* 	lContactID : lContactID is of tContactCategories                                          */
/* 	lCategoryID : lCategoryID is of tContactCategories                                        */  
create table tContactCategories ( 
	lContactCategoryID int identity not null,
	lContactID int not null,
	lCategoryID int not null)  

go

alter table tContactCategories
	add constraint tContactCategories_PK primary key (lContactCategoryID)   
go

/* Create new table tCategories.                                                              */
/* tCategories : Table of tCategories                                                         */
/* 	lCategoryID : lCategoryID identifies tCategories                                          */
/* 	strDesignation : strDesignation is of tCategories                                         */
/* 	strRemarks : strRemarks is of tCategories                                                 */  
create table tCategories ( 
	lCategoryID int identity not null,
	strDesignation varchar(100) not null,
	strRemarks varchar(2000) null)  

go

alter table tCategories
	add constraint tCategories_PK primary key (lCategoryID)   
go


/* Create new table tScheduledItem.                                                     */
/* tScheduledItem : tScheduledItem of tScheduledItem                                    */
/* 	lScheduledItemID : lScheduledItemID identifies tScheduledItem                   */
/* 	lStructureID : lStructureID is of tScheduledItem                               	*/
/* 	lEmployeeID : lEmployeeID is of tScheduledItem                               	*/
/* 	dtFrom : dtFrom is of tScheduledItem                               		*/
/* 	dtTo : lStructureID is of tScheduledItem                               		*/
/* 	lDuration : lDuration is of tScheduledItem                               	*/
/* 	strRemarks : strRemarks is of tScheduledItem                               	*/
/* 	bIsFixed : bIsFixed is of tScheduledItem                               		*/
create table tScheduledItem ( 
	lScheduledItemID int identity not null, 
	lStructureID int not null, 
	lEmployeeID int not null, 
	dtFrom smalldatetime not null,
	dtTo smalldatetime not null, 
	lDuration int not null,
	strRemarks varchar(1000) null,
	bIsFixed bit not null)  
GO

alter table tScheduledItem
	add constraint tScheduledItem_PK primary key clustered (lScheduledItemID)   

GO


/* Add the remaining keys, constraints and indexes for the table tToolsLoaded.                */
alter table tToolsLoaded add constraint tToolsLoaded_UC1 unique (
	lToolID)  


go

/* Add the remaining keys, constraints and indexes for the table tMasterCurrencies.           */
alter table tMasterCurrencies add constraint tMasterCurrencies_UC1 unique (
	strCurrency)  


go

/* Add the remaining keys, constraints and indexes for the table tMasterAccounts.             */
alter table tMasterAccounts add constraint tMasterAccounts_UC1 unique (
	strAccountNo)  


go

/* Add the remaining keys, constraints and indexes for the table tInvoices.                   */
alter table tInvoices add constraint tInvoices_UC1 unique (
	lInvoiceNo)  


go

/* Add the remaining keys, constraints and indexes for the table tProjects.                   */
alter table tProjects add constraint tProjects_UC1 unique (
	strProjectNo)  


go

/* Add the remaining keys, constraints and indexes for the table tCostCenter.                   */
alter table tCostCenter add constraint tCostCenter_UC1 unique (
	strCostCenterNo)  
go

/* Add the remaining keys, constraints and indexes for the table tCostUnit.                   */
alter table tCostUnit add constraint tCostUnit_UC1 unique (
	strCostUnitNo)  
go


/* Add the remaining keys, constraints and indexes for the table tEmployees.                  */
alter table tEmployees add constraint tEmployees_UC1 unique (
	strLogin)  


go

alter table tEmployees add constraint tEmployees_UC2 unique (
	lPersonalNo)  


go

/* Add the remaining keys, constraints and indexes for the table tAuthorisationGroup.                   */
alter table tAuthorisationGroup add constraint tAuthorisationGroup_UC1 unique (
	strDesignation)  
go

/* Add the remaining keys, constraints and indexes for the table tScale.                   */
alter table tScale add constraint tScale_UC1 unique (
	strDesignation)  
go


/* Add the remaining keys, constraints and indexes for the table tDepartment.                   */
alter table tDepartment add constraint tDepartment_UC1 unique (
	strDesignation)  
go


/* Add foreign key constraints to table tInvCurFactors                                   */
alter table tInvCurFactors
	add constraint tInvoices_tInvCurFactors_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  
go

alter table tInvCurFactors
	add constraint tMasterCurrencies_tInvCurFactors_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  
go

/* Add index to table tInvCurFactors */
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tInvCurFactors]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tInvCurFactors]([lCurrencyID])
go


/* Add foreign key constraints to table tContactCategories.                                   */
alter table tContactCategories
	add constraint tCategories_tContactCategories_FK1 foreign key (
		lCategoryID)
	 references tCategories (
		lCategoryID)  

go

alter table tContactCategories
	add constraint tContacts_tContactCategories_FK1 foreign key (
		lContactID)
	 references dbo.tContacts (
		lContactID)  

go

/* Add index to table tContactCategories */
CREATE NONCLUSTERED INDEX [IX_ContactID_FK] ON [dbo].[tContactCategories]([lContactID])
go
CREATE NONCLUSTERED INDEX [IX_CategoryID_FK] ON [dbo].[tContactCategories]([lCategoryID])
go


/* Add foreign key constraints to table tBookingsLog.                                         */
alter table tBookingsLog
	add constraint tBookings_tBookingsLog_FK1 foreign key (
		lBookingID)
	 references tBookings (
		lBookingID)  

go

/* Add index to table tBookingsLog */
CREATE NONCLUSTERED INDEX [IX_BookingID_FK] ON [dbo].[tBookingsLog]([lBookingID])
go


/* Add foreign key constraints to table tBookings.                                            */
alter table tBookings
	add constraint tEmployees_tBookings_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go


/* Add index to table tBookings */
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tBookings]([lEmployeeID])
go

/* Add foreign key constraints to table tEmployment.                                          */
alter table tEmployment
	add constraint tEmployees_tEmployment_FK1 foreign key (
		lEmployeeID)
	 references dbo.tEmployees (
		lEmployeeID)  

go

/* Add index to table tEmployment.								*/
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tEmployment]([lEmployeeID])
go


/* Add foreign key constraints to table tIntHourlyRate.                                          */
alter table tIntHourlyRate
	add constraint tEmployees_tIntHourlyRate_FK1 foreign key (
		lEmployeeID)
	 references dbo.tEmployees (
		lEmployeeID)  

go

/* Add index to table tIntHourlyRate */
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tIntHourlyRate]([lEmployeeID])
go

/* Add foreign key constraints to table tPayments.                                            */
alter table tPayments
	add constraint tMasterAccounts_tInvoices_FK1 foreign key (
		lAccountNoID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tPayments
	add constraint tInvoices_tPayments_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

go


/* Add index to table tPayments */
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tPayments]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_AccountNoID_FK] ON [dbo].[tPayments]([lAccountNoID])
go

/* Add foreign key constraints to table tFees.                                                */
alter table tFees
	add constraint tInvoices_tFees_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

go

alter table tFees
	add constraint tFeeTasks_tFees_FK1 foreign key (
		lFeeTaskID)
	 references tFeeTasks (
		lFeeTaskID)  

go

alter table tFees
	add constraint tMasterCurrencies_tFees_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

/* Add index to table tFees */
CREATE NONCLUSTERED INDEX [IX_FeeTaskID_FK] ON [dbo].[tFees]([lFeeTaskID])
go
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tFees]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tFees]([lCurrencyID])
go


/* Add foreign key constraints to table tCreditBalanceCorrections.                            */
alter table tCreditBalanceCorrections
	add constraint tEmployees_tCreditBalanceCorrections_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

/* Add index to table tCreditBalanceCorrections */
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tCreditBalanceCorrections]([lEmployeeID])
go


/* Add foreign key constraints to table tFavorites.                                           */
alter table tFavorites
	add constraint tActivities_tFavorites_FK1 foreign key (
		lActivityID)
	 references tActivities (
		lActivityID)  

go

alter table tFavorites
	add constraint tEmployees_tFavorites_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

/* Add index to table tFavorites */
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tFavorites]([lEmployeeID])
go
CREATE NONCLUSTERED INDEX [IX_ActivityID_FK] ON [dbo].[tFavorites]([lActivityID])
go


/* Add foreign key constraints to table tTaxKeyValidities.                                    */
alter table tTaxKeyValidities
	add constraint tMasterTaxKeys_tTaxKeyValidities_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

/* Add index to table tTaxKeyValidities */
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tTaxKeyValidities]([lTaxKeyID])
go

/* Add foreign key constraints to table tToolsLoaded.                                         */
alter table tToolsLoaded
	add constraint tTools_tToolsLoaded_FK1 foreign key (
		lToolID)
	 references tTools (
		lToolID)  

go

/* Add index to table tToolsLoaded */
CREATE NONCLUSTERED INDEX [IX_ToolID_FK] ON [dbo].[tToolsLoaded]([lToolID])
go

/* Add foreign key constraints to table tTools.                                               */
alter table tTools
	add constraint tEmployees_tTools_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

/* Add index to table tTools */
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tTools]([lEmployeeID])
go

/* Add foreign key constraints to table tMasterTaxKeys.                                       */
alter table tMasterTaxKeys
	add constraint tMasterAccounts_tMasterTaxKeys_FK1 foreign key (
		lPassiveAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

/* Add table to table tMasterTaxKeys */
CREATE NONCLUSTERED INDEX [IX_PassiveAccountID_FK] ON [dbo].[tMasterTaxKeys]([lPassiveAccountID])
go

/* Add foreign key constraints to table tMasterMaterials.                                     */
alter table tMasterMaterials
	add constraint tMasterAccounts_tMasterMaterials_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tMasterMaterials
	add constraint tMasterTaxKeys_tMasterMaterials_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tMasterMaterials
	add constraint tMasterCurrencies_tMasterMaterials_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go


/* Add index to table tMasterMaterials */
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tMasterMaterials]([lIncomeAccountID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tMasterMaterials]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tMasterMaterials]([lCurrencyID])
go


/* Add foreign key constraints to table tMasterExpenses.                                      */
alter table tMasterExpenses
	add constraint tMasterAccounts_tMasterExpenses_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tMasterExpenses
	add constraint tMasterAccounts_tMasterExpenses_FK2 foreign key (
		lExpenseAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tMasterExpenses
	add constraint tMasterTaxKeys_tMasterExpenses_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tMasterExpenses
	add constraint tMasterCurrencies_tMasterExpenses_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go


/* Add index to table tMasterExpenses */
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tMasterExpenses]([lIncomeAccountID])
go
CREATE NONCLUSTERED INDEX [IX_ExpenseAccountID_FK] ON [dbo].[tMasterExpenses]([lExpenseAccountID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tMasterExpenses]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tMasterExpenses]([lCurrencyID])
go


/* Add foreign key constraints to table tLumpSums.                                            */
alter table tLumpSums
	add constraint tProjects_tLumpSums_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  

go

alter table tLumpSums
	add constraint tInvoices_tLumpSums_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

go

alter table tLumpSums
	add constraint tMasterCurrencies_tLumpSums_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

alter table tLumpSums
	add constraint tMasterTaxKeys_tLumpSums_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tLumpSums
	add constraint tMasterAccounts_tLumpSums_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go


/* Add index to table tLumpSums */
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tLumpSums]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tLumpSums]([lProjectID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tLumpSums]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tLumpSums]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tLumpSums]([lIncomeAccountID])
go


/* Add foreign key constraints to table tAccPayments.                                            */
alter table tAccPayments
	add constraint tInvoices_tAccPayments_FK1 foreign key (
		lAccPaymInvID)
	 references tInvoices (
		lInvoiceID)  

GO

alter table tAccPayments
	add constraint tInvoices_tAccPayments_FK2 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

GO

alter table tAccPayments
	add constraint tProjects_tAccPayments_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  

GO

alter table tAccPayments
	add constraint tMasterCurrencies_tAccPayments_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

GO

alter table tAccPayments
	add constraint tMasterTaxKeys_tAccPayments_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

GO

alter table tAccPayments
	add constraint tMasterAccounts_tAccPayments_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

GO


/* Add index to table tAccPayments */
CREATE NONCLUSTERED INDEX [IX_AccPaymInvID_FK] ON [dbo].[tAccPayments]([lAccPaymInvID])
go
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tAccPayments]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tAccPayments]([lProjectID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tAccPayments]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tAccPayments]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tAccPayments]([lIncomeAccountID])
go


/* Add foreign key constraints to table tFeeTasks.                                            */
alter table tFeeTasks
	add constraint tProjects_tFeeTasks_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  

go

alter table tFeeTasks
	add constraint tMasterCurrencies_tFeeTasks_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

alter table tFeeTasks
	add constraint tMasterTaxKeys_tFeeTasks_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tFeeTasks
	add constraint tMasterAccounts_tFeeTasks_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go


/* Add index to table tFeeTasks */
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tFeeTasks]([lProjectID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tFeeTasks]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tFeeTasks]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tFeeTasks]([lIncomeAccountID])
go


/* Add foreign key constraints to table tProjectDocuments.                                            */
alter table tProjectDocuments
	add constraint tProjects_tProjectDocuments_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  

go

/* Add index to table tProjectDocuments */
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tProjectDocuments]([lProjectID])
go


/* Add foreign key constraints to table tInvoices.                                            */
alter table tInvoices
	add constraint tMasterCurrencies_tInvoices_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

alter table tInvoices
	add constraint tLanguages_tInvoices_FK1 foreign key (
		lLanguageID)
	 references tLanguages (
		lLanguageID)  

go

alter table tInvoices
	add constraint tEmployees_tInvoices_FK1 foreign key (
		lCreatorID)
	 references tEmployees (
		lEmployeeID)  

go

alter table tInvoices
	add constraint tProjects_tInvoices_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  
go

alter table tInvoices
	add constraint tInvoiceRptDefinition_tInvoices_FK1 foreign key (
		lInvoiceRptDefinitionID)
	 references tInvoiceRptDefinition (
		lInvoiceRptDefinitionID)  
go

alter table tInvoices
	add constraint tMasterInvoiceState_tInvoices_FK1 foreign key (
		lMasterInvoiceStateID)
	 references tMasterInvoiceState (
		lMasterInvoiceStateID)  
go


/* Add index to table tInvoices */
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tInvoices]([lProjectID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tInvoices]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_LanguageID_FK] ON [dbo].[tInvoices]([lLanguageID])
go
CREATE NONCLUSTERED INDEX [IX_CreatorID_FK] ON [dbo].[tInvoices]([lCreatorID])
go
CREATE NONCLUSTERED INDEX [IX_InvoiceRptDefinitionID_FK] ON [dbo].[tInvoices]([lInvoiceRptDefinitionID])
go
CREATE NONCLUSTERED INDEX [IX_MasterInvoiceStateID_FK] ON [dbo].[tInvoices] ([lMasterInvoiceStateID])  
go


/* Add foreign key constraints to table tProjectTeam.                                         */
alter table tProjectTeam
	add constraint tProjects_tProjectTeam_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  

go

alter table tProjectTeam
	add constraint tEmployees_tProjectTeam_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

/* Add index to table tProjectTeam */
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tProjectTeam]([lProjectID])
go
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tProjectTeam]([lEmployeeID])
go

/* Add foreign key constraints to table tMasterActivities.                                    */
alter table tMasterActivities
	add constraint tMasterAccounts_tMasterActivities_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tMasterActivities
	add constraint tMasterTaxKeys_tMasterActivities_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tMasterActivities
	add constraint tMasterCurrencies_tMasterActivities_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go


/* Add index to table tMasterActivities */
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tMasterActivities]([lIncomeAccountID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tMasterActivities]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tMasterActivities]([lCurrencyID])
go


/* Add foreign key constraints to table tActivities.                                          */
alter table tActivities
	add constraint tMasterActivities_tActivities_FK1 foreign key (
		lMasterActivityID)
	 references tMasterActivities (
		lMasterActivityID)  

go

alter table tActivities
	add constraint tMasterTaxKeys_tActivities_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tActivities
	add constraint tMasterAccounts_tActivities_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go


/* Add index to table tActivities */
CREATE NONCLUSTERED INDEX [IX_MasterActivityID_FK] ON [dbo].[tActivities]([lMasterActivityID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tActivities]([lIncomeAccountID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tActivities]([lTaxKeyID])
go


/* Add foreign key constraints to table tStructures.                                          */
alter table tStructures
	add constraint tStructures_tStructures_FK1 foreign key (
		lParentID)
	 references tStructures (
		lStructureID)  

go

alter table tStructures
	add constraint tProjects_tStructures_FK1 foreign key (
		lProjectID)
	 references tProjects (
		lProjectID)  

go

alter table tStructures
	add constraint tActivities_tStructures_FK1 foreign key (
		lActivityID)
	 references tActivities (
		lActivityID)  

go


/* Add index to table tStructures */
CREATE NONCLUSTERED INDEX [IX_ParentID_FK] ON [dbo].[tStructures]([lParentID])
go
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tStructures]([lProjectID])
go
CREATE NONCLUSTERED INDEX [IX_ActivityID_FK] ON [dbo].[tStructures]([lActivityID])
go


/* Add foreign key constraints to table tExpenseServices.                                     */
alter table tExpenseServices
	add constraint tStructures_tExpenseServices_FK1 foreign key (
		lStructureID)
	 references tStructures (
		lStructureID)  

go

alter table tExpenseServices
	add constraint tInvoices_tExpenseServices_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

go

alter table tExpenseServices
	add constraint tEmployees_tExpenseServices_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

alter table tExpenseServices
	add constraint tMasterCurrencies_tExpenseServices_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

alter table tExpenseServices
	add constraint tMasterExpenses_tExpenseServices_FK1 foreign key (
		lMasterExpenseID)
	 references tMasterExpenses (
		lMasterExpenseID)  

go

alter table tExpenseServices
	add constraint tMasterTaxKeys_tExpenseServices_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tExpenseServices
	add constraint tMasterAccounts_tExpenseServices_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go


/* Add index to table tExpenseServices */
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tExpenseServices]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_StructureID_FK] ON [dbo].[tExpenseServices]([lStructureID])
go
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tExpenseServices]([lEmployeeID])
go
CREATE NONCLUSTERED INDEX [IX_MasterExpenseID_FK] ON [dbo].[tExpenseServices]([lMasterExpenseID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tExpenseServices]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tExpenseServices]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tExpenseServices]([lIncomeAccountID])
go


/* Add foreign key constraints to table tMaterialServices.                                    */
alter table tMaterialServices
	add constraint tStructures_tMaterialServices_FK1 foreign key (
		lStructureID)
	 references tStructures (
		lStructureID)  

go

alter table tMaterialServices
	add constraint tInvoices_tMaterialServices_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

go

alter table tMaterialServices
	add constraint tEmployees_tMaterialServices_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

alter table tMaterialServices
	add constraint tMasterCurrencies_tMaterialServices_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

alter table tMaterialServices
	add constraint tMasterMaterials_tMaterialServices_FK1 foreign key (
		lMasterMaterialID)
	 references tMasterMaterials (
		lMasterMaterialID)  

go

alter table tMaterialServices
	add constraint tMasterAccounts_tMaterialServices_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tMaterialServices
	add constraint tMasterTaxKeys_tMaterialServices_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go


/* Add index to table tMaterialServices */
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tMaterialServices]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_StructureID_FK] ON [dbo].[tMaterialServices]([lStructureID])
go
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tMaterialServices]([lEmployeeID])
go
CREATE NONCLUSTERED INDEX [IX_MasterMaterialID_FK] ON [dbo].[tMaterialServices]([lMasterMaterialID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tMaterialServices]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tMaterialServices]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tMaterialServices]([lIncomeAccountID])
go


/* Add foreign key constraints to table tTimeServices.                                        */
alter table tTimeServices
	add constraint tInvoices_tTimeServices_FK1 foreign key (
		lInvoiceID)
	 references tInvoices (
		lInvoiceID)  

go

alter table tTimeServices
	add constraint tEmployees_tTimeServices_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go

alter table tTimeServices
	add constraint tMasterCurrencies_tTimeServices_FK1 foreign key (
		lCurrencyID)
	 references tMasterCurrencies (
		lMasterCurrencyID)  

go

alter table tTimeServices
	add constraint tMasterTaxKeys_tTimeServices_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tTimeServices
	add constraint tMasterAccounts_tTimeServices_FK1 foreign key (
		lIncomeAccountID)
	 references tMasterAccounts (
		lMasterAccountID)  

go

alter table tTimeServices
	add constraint tActivities_tTimeServices_FK1 foreign key (
		lActivityID)
	 references tActivities (
		lActivityID)  

go


/* Add index to table tTimeServices */
CREATE NONCLUSTERED INDEX [IX_InvoiceID_FK] ON [dbo].[tTimeServices]([lInvoiceID])
go
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tTimeServices]([lEmployeeID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tTimeServices]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tTimeServices]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tTimeServices]([lIncomeAccountID])
go
CREATE NONCLUSTERED INDEX [IX_ActivityID_FK] ON [dbo].[tTimeServices]([lActivityID])
go


/* Add foreign key constraints to table tContacts.                                            */
alter table tContacts
	add constraint tOrganisations_tContacts_FK1 foreign key (
		lOrganizationID)
	 references tOrganizations (
		lOrganizationID)  

go

alter table tContacts
	add constraint tMasterTaxKeys_tContacts_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

/* Add index to table tContacts */
CREATE NONCLUSTERED INDEX [IX_OrganizationID_FK] ON [dbo].[tContacts]([lOrganizationID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tContacts]([lTaxKeyID])
go


/* Add foreign key constraints to table tProjects.                                            */
alter table tProjects
	add constraint tContacts_tProjects_FK1 foreign key (
		lContactID)
	 references tContacts (
		lContactID)  

go

alter table tProjects
	add constraint tContacts_tProjects_FK2 foreign key (
		lBrokerID)
	 references dbo.tContacts (
		lContactID)  

go

alter table tProjects
	add constraint tMasterTaxKeys_tProjects_FK1 foreign key (
		lTaxKeyID)
	 references tMasterTaxKeys (
		lMasterTaxKeyID)  

go

alter table tProjects
	add constraint tMasterCurrencies_tProjects_FK1 foreign key (
		lCurrencyID)
	 references dbo.tMasterCurrencies (
		lMasterCurrencyID)  

go


alter table tProjects
	add constraint tProjectType_tProjects_FK1 foreign key (
		lProjectTypeID)
	 references dbo.tProjectType (
		lProjectTypeID)  

go

alter table tProjects
	add constraint tCostUnit_tProjects_FK1 foreign key (
		lCostUnitID)
	 references dbo.tCostUnit (
		lCostUnitID)  
go

alter table tProjects
	add constraint tMasterAccounts_tProjects_FK1 foreign key (
		lIncomeAccountID)
	 references dbo.tMasterAccounts (
		lMasterAccountID)  
go

alter table tProjects
	add constraint tInvoiceRptDefinition_tProjects_FK1 foreign key (
		lInvoiceRptDefinitionID)
	 references dbo.tInvoiceRptDefinition (
		lInvoiceRptDefinitionID)  
go

alter table tProjects
	add constraint tMasterInvConditions_tProjects_FK1 foreign key (
		lMasterInvCondID)
	 references dbo.tMasterInvConditions (
		lMasterInvCondID)  
go


/* Add index to table tProjects */
CREATE NONCLUSTERED INDEX [IX_ContactID_FK] ON [dbo].[tProjects]([lContactID])
go
CREATE NONCLUSTERED INDEX [IX_TaxKeyID_FK] ON [dbo].[tProjects]([lTaxKeyID])
go
CREATE NONCLUSTERED INDEX [IX_BrokerID_FK] ON [dbo].[tProjects]([lBrokerID])
go
CREATE NONCLUSTERED INDEX [IX_CurrencyID_FK] ON [dbo].[tProjects]([lCurrencyID])
go
CREATE NONCLUSTERED INDEX [IX_ProjectTypeID_FK] ON [dbo].[tProjects]([lProjectTypeID])
go
CREATE NONCLUSTERED INDEX [IX_CostUnitID_FK] ON [dbo].[tProjects]([lCostUnitID])
go
CREATE NONCLUSTERED INDEX [IX_IncomeAccountID_FK] ON [dbo].[tProjects]([lIncomeAccountID])
go
CREATE NONCLUSTERED INDEX [IX_InvoiceRptDefinitionID_FK] ON [dbo].[tProjects]([lInvoiceRptDefinitionID])
go
CREATE NONCLUSTERED INDEX [IX_MasterInvCondID_FK] ON [dbo].[tProjects] ([lMasterInvCondID])  
go

/* Add foreign key constraints to table tEmployees.                                           */
alter table tEmployees
	add constraint tLanguages_tEmployees_FK1 foreign key (
		lLanguageID)
	 references tLanguages (
		lLanguageID)  

go
alter table tEmployees
	add constraint tAuthGroup_tEmployees_FK1 foreign key (
		lAuthorisationGroupID)
	 references tAuthorisationGroup (
		lAuthorisationGroupID)  

go
alter table tEmployees
	add constraint tScale_tEmployees_FK1 foreign key (
		lScaleID)
	 references tScale (
		lScaleID)  
go
alter table tEmployees
	add constraint tDepartment_tEmployees_FK1 foreign key (
		lDepartmentID)
	 references tDepartment (
		lDepartmentID)  
go

alter table tEmployees
	add constraint tCostCenter_tEmployees_FK1 foreign key (
		lCostCenterID)
	 references dbo.tCostCenter (
		lCostCenterID)  

go

/* Add index to table tEmployees */
CREATE NONCLUSTERED INDEX [IX_LanguageID_FK] ON [dbo].[tEmployees]([lLanguageID])
go
CREATE NONCLUSTERED INDEX [IX_AuthorisationGroupID_FK] ON [dbo].[tEmployees]([lAuthorisationGroupID])
go
CREATE NONCLUSTERED INDEX [IX_ScaleID_FK] ON [dbo].[tEmployees]([lScaleID])
go
CREATE NONCLUSTERED INDEX [IX_DepartmentID_FK] ON [dbo].[tEmployees]([lDepartmentID])
go
CREATE NONCLUSTERED INDEX [IX_CostCenterID_FK] ON [dbo].[tEmployees]([lCostCenterID])
go


/* Add foreign key constraints to table tTasks.                                          */
alter table tTasks
	add constraint tEmployees_tTasks_FK1 foreign key (
		lCreatorID)
	 references dbo.tEmployees (
		lEmployeeID)  
go
alter table tTasks
	add constraint tEmployees_tTasks_FK2 foreign key (
		lResponsibleID)
	 references dbo.tEmployees (
		lEmployeeID)  
go
alter table tTasks
	add constraint tContacts_tTasks_FK1 foreign key (
		lContactID)
	 references dbo.tContacts (
		lContactID)  
go
alter table tTasks
	add constraint tProjects_tTasks_FK1 foreign key (
		lProjectID)
	 references dbo.tProjects (
		lProjectID)  
go

/* Add index to table tTasks */
CREATE NONCLUSTERED INDEX [IX_CreatorID_FK] ON [dbo].[tTasks]([lCreatorID])
go
CREATE NONCLUSTERED INDEX [IX_ResponsibleID_FK] ON [dbo].[tTasks]([lResponsibleID])
go
CREATE NONCLUSTERED INDEX [IX_ContactID_FK] ON [dbo].[tTasks]([lContactID])
go
CREATE NONCLUSTERED INDEX [IX_ProjectID_FK] ON [dbo].[tTasks]([lProjectID])
go


/* Add foreign key constraints to table tInvoiceRptDefinition.                                          */
alter table tInvoiceRptDefinition
	add constraint tLanguages_tInvoiceRptDefinition_FK1 foreign key (
		lLanguageID)
	 references dbo.tLanguages (
		lLanguageID)  
go

/* Add index to table tInvoiceRptDefinition */
CREATE NONCLUSTERED INDEX [IX_LanguageID_FK] ON [dbo].[tInvoiceRptDefinition]([lLanguageID])
go


/* Add foreign key constraints to table tInvoiceRptFile.                                          */
alter table tInvoiceRptFile
	add constraint tInvoiceRptDefinition_tInvoiceRptFile_FK1 foreign key (
		lInvoiceRptDefinitionID)
	 references dbo.tInvoiceRptDefinition (
		lInvoiceRptDefinitionID)  
go

alter table tInvoiceRptFile
	add constraint tPrinter_tInvoiceRptFile_FK1 foreign key (
		lPrinterID)
	 references dbo.tPrinter (
		lPrinterID)  
go

/* Add index to table tInvoiceRptFile */
CREATE NONCLUSTERED INDEX [IX_PrinterID_FK] ON [dbo].[tInvoiceRptFile]([lPrinterID])
go


/* Add foreign key constraints to table tTimeSrvRpt.                                          */
alter table tTimeSrvRpt
	add constraint tInvoiceRptFile_tTimeSrvRpt_FK1 foreign key (
		lInvoiceRptDefinitionID,
		lSheetType)
	 references dbo.tInvoiceRptFile (
		lInvoiceRptDefinitionID,
		lSheetType)  
go


/* Add foreign key constraints to table tExpenseSrvRpt.                                          */
alter table tExpenseSrvRpt
	add constraint tInvoiceRptFile_tExpenseSrvRpt_FK1 foreign key (
		lInvoiceRptDefinitionID,
		lSheetType)
	 references dbo.tInvoiceRptFile (
		lInvoiceRptDefinitionID,
		lSheetType)
go


/* Add foreign key constraints to table tMaterialSrvRpt.                                          */
alter table tMaterialSrvRpt
	add constraint tInvoiceRptFile_tMaterialSrvRpt_FK1 foreign key (
		lInvoiceRptDefinitionID,
		lSheetType)
	 references dbo.tInvoiceRptFile (
		lInvoiceRptDefinitionID,
		lSheetType)  
go


/* Add foreign key constraints to table tScheduledItem.                                           */
alter table tScheduledItem
	add constraint tStructures_tScheduledItem_FK1 foreign key (
		lStructureID)
	 references tStructures (
		lStructureID)  

go
alter table tScheduledItem
	add constraint tEmployees_tScheduledItem_FK1 foreign key (
		lEmployeeID)
	 references tEmployees (
		lEmployeeID)  

go


/* Indizesse erzeugen										*/
CREATE NONCLUSTERED INDEX [IX_StructureID_FK] ON [dbo].[tScheduledItem]([lStructureID])
go
CREATE NONCLUSTERED INDEX [IX_EmployeeID_FK] ON [dbo].[tScheduledItem]([lEmployeeID])
go




/* INSERT TRIGGER um zu gewhrleisten, das die Ttigkeits Id
   NULL sein kann, aber eindeutig sein muss, falls definiert 
   
   Autor:	Mike Kaufmann
   Datum:	12.03.2001
   
*/
CREATE TRIGGER tStructuresins ON tStructures for insert
as
     declare @errorNumber int,
    	     @errorMsg varchar(255)
begin

  /* trigger for insert */
  if not (select lActivityID FROM inserted) is null
  begin
   if (select count(*) from inserted, tStructures 
    where (tStructures.lActivityID = inserted.lActivityID) ) > 1
    begin
      select @errorNumber = 30002, @errorMsg = 'Die Ttigkeits ID muss eindeutig sein'
      goto errorHandler
    end
  end


  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO


/* Die Ttigkeits ID muss eindeutig sein,
   sofern sie definiert ( <> NULL) ist.
   
   Autor:	Mike Kaufmann
   Datum:	12.03.2001
   
*/
CREATE Trigger tStructuresupd on tStructures 
for update 
as
BEGIN
  declare
	@rowsAffected int,
	@nullRows int,
	@validRows int, 
	@errorNumber int,
	@errorMsg varchar(255)

  select @rowsAffected = @@rowcount

/* UPDATE Trigger von lActivityID */
if
update(lActivityID)
  begin
    if not (select lActivityID FROM inserted) is null
    begin
      if (select count(*) from inserted, tStructures 
          where (tStructures.lActivityID = inserted.lActivityID) ) > 1
        begin
          select @errorNumber = 30002,
                 @errorMsg = 'Die Ttigkeits ID muss eindeutig sein'
          goto errorHandler
        end
    end
  end


  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO


/* INSERT TRIGGER um zu gewhrleisten, das eine Pauschalleistung
   als verrechneten Betrag immer 0 aufweist
   
   Autor:		Mike Kaufmann
   Datum:	13.11.2002
   
*/
CREATE TRIGGER tExpenseServicesins ON tExpenseServices for insert
as
     declare @errorNumber int,
    	     @errorMsg varchar(255)
begin

  /* trigger for insert */
  if ((select bForInvoice  FROM inserted) = 0) AND ((select decAmountInvoiced FROM inserted) > 0)
  begin
    select @errorNumber = 30002, @errorMsg = 'Eine pauschale Spesenleistung muss als verrechneten Wert immer 0.00 aufweisen'
     goto errorHandler
  end


  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO

/* UPDATE TRIGGER um zu gewhrleisten, das eine Pauschalleistung
   als verrechneten Betrag immer 0 aufweist
   
   Autor:		Mike Kaufmann
   Datum:	13.11.2002
   
*/
CREATE Trigger tExpenseServicesupd on tExpenseServices 
for update 
as
BEGIN
  declare
	@rowsAffected int,
	@nullRows int,
	@validRows int, 
	@errorNumber int,
	@errorMsg varchar(255)

  select @rowsAffected = @@rowcount

  /* UPDATE Trigger von bForInvoice und decAmountInvoiced */
  /* Prfung wird nur gemacht, wenn 1 Eintrag in der Tabelle inserted steht */
  if @rowsAffected=1
  begin
    if
    update(bForInvoice)
    begin
      if ((select decAmountInvoiced FROM inserted) > 0) AND ((select bForInvoice FROM inserted) = 0)
      begin
        select @errorNumber = 30002,
          @errorMsg = 'Eine pauschale Spesenleistung muss als verrechneten Wert immer 0.00 aufweisen'
          goto errorHandler
       end
    end

    if
    update(decAmountInvoiced)
    begin
      if ((select decAmountInvoiced FROM inserted) > 0) AND ((select bForInvoice FROM inserted) = 0)
      begin
        select @errorNumber = 30002,
          @errorMsg = 'Eine pauschale Spesenleistung muss als verrechneten Wert immer 0.00 aufweisen'
          goto errorHandler
      end
    end
  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO

/* INSERT TRIGGER um zu gewhrleisten, das eine Pauschalleistung
   als verrechnete Dauer immer den Wert 0 aufweist.
   Es wird auch geprft, dass der Unterschied zwischen Von und Bis gleich
   der abgespeicherten Dauer ist und das Von und Bis an demselben Tag liegen
   
   Autor:		Mike Kaufmann
   Datum:		12.10.2004
   
*/
CREATE TRIGGER tTimeServicesins ON tTimeServices for insert
as
     declare @errorNumber int,
    	     @errorMsg varchar(255)
begin

  /* trigger for insert */
  if ((select bForInvoice  FROM inserted) = 0) AND ((select lDurationInvoiced FROM inserted) > 0)
  begin
    select @errorNumber = 30002, @errorMsg = 'Eine pauschale Zeitleistung muss als verrechnete Dauer den Wert 0 haben'
     goto errorHandler
  end

  /* Von und Bis an demselben Tag? */ 
  /* Differenz Von Bis = Dauer ? */
  if ((select dtTo FROM inserted) IS NOT NULL)
  begin
	/* Von und Bis an demselben Tag? */
	if ((select DateDiff(d, dtFrom, dtTo) FROM inserted) <> 0) 
	begin
          	select @errorNumber = 30004, @errorMsg = 'Das Von- und das Bis Datum eines Zeiteintrages mssen an demselben Tag sein'
        	goto errorHandler
	end
	/* Differenz Von Bis = Dauer ? */
	if ((select DateDiff(s, dtFrom, dtTo) FROM inserted) <> (select lDuration FROM inserted) ) 
	begin
    		select @errorNumber = 30003, @errorMsg = 'Die Differenz zwischen Von und Bis und die Dauer mssen bereinstimmen'
     		goto errorHandler
	end
  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO


/* UPDATE TRIGGER um zu gewhrleisten, das eine Pauschalleistung
   als verrechnete Dauer immer 0 aufweist
   
   Autor:		Mike Kaufmann
   Datum:	13.11.2002
   
*/
CREATE Trigger tTimeServicesupd on tTimeServices 
for update 
as
BEGIN
  declare
	@rowsAffected int,
	@nullRows int,
	@validRows int, 
	@errorNumber int,
	@errorMsg varchar(255)

  select @rowsAffected = @@rowcount

  /* UPDATE Trigger von bForInvoice und lDurationInvoiced */
  /* Test wird nur gemacht, wenn ein Eintrag in der Tabelle inserted steht */
  if @rowsAffected=1
  begin
    if
    update(bForInvoice)
    begin
      if ((select lDurationInvoiced FROM inserted) > 0) AND ((select bForInvoice FROM inserted) = 0)
      begin
        select @errorNumber = 30002,
          @errorMsg = 'Eine pauschale Zeitleistung muss als verrechnete Dauer den Wert 0 haben'
          goto errorHandler
       end
    end

    if
    update(lDurationInvoiced)
    begin
      if ((select lDurationInvoiced FROM inserted) > 0) AND ((select bForInvoice FROM inserted) = 0)
      begin
        select @errorNumber = 30002,
          @errorMsg = 'Eine pauschale Zeitleistung muss als verrechnete Dauer den Wert 0 haben'
          goto errorHandler
      end
    end

    if
    update(dtFrom)
    begin
      /* Von und Bis an demselben Tag? */
      /* Differenz Von Bis = Dauer ? */
      if ((select dtTo FROM inserted) IS NOT NULL)
      begin
        /* Von und Bis an demselben Tag? */
	if ((select DateDiff(d, dtFrom, dtTo) FROM inserted) <> 0) 
	begin
          	select @errorNumber = 30004, @errorMsg = 'Das Von- und das Bis Datum eines Zeiteintrages mssen an demselben Tag sein'
        	goto errorHandler
	end
	/* Differenz Von Bis = Dauer ? */
	if ((select DateDiff(s, dtFrom, dtTo) FROM inserted) <> (select lDuration FROM inserted) ) 
        begin
          	select @errorNumber = 30003, @errorMsg = 'Die Differenz zwischen Von und Bis und die Dauer mssen bereinstimmen'
           	goto errorHandler
        end
      end
    end

    if
    update(dtTo)
    begin
      /* Von und Bis an demselben Tag? */
      /* Differenz Von Bis = Dauer ? */
      if ((select dtTo FROM inserted) IS NOT NULL)
      begin
        /* Von und Bis an demselben Tag? */
	if ((select DateDiff(d, dtFrom, dtTo) FROM inserted) <> 0) 
	begin
          	select @errorNumber = 30004, @errorMsg = 'Das Von- und das Bis Datum eines Zeiteintrages mssen an demselben Tag sein'
        	goto errorHandler
	end
	/* Differenz Von Bis = Dauer ? */
	if ((select DateDiff(s, dtFrom, dtTo) FROM inserted) <> (select lDuration FROM inserted) ) 
        begin
          	select @errorNumber = 30003, @errorMsg = 'Die Differenz zwischen Von und Bis und die Dauer mssen bereinstimmen'
           	goto errorHandler
        end
      end
    end

    if
    update(lDuration)
    begin
      /* Von und Bis an demselben Tag? */
      /* Differenz Von Bis = Dauer ? */
      if ((select dtTo FROM inserted) IS NOT NULL)
      begin
        /* Von und Bis an demselben Tag? */
	if ((select DateDiff(d, dtFrom, dtTo) FROM inserted) <> 0) 
	begin
          	select @errorNumber = 30004, @errorMsg = 'Das Von- und das Bis Datum eines Zeiteintrages mssen an demselben Tag sein'
        	goto errorHandler
	end
	/* Differenz Von Bis = Dauer ? */
	if ((select DateDiff(s, dtFrom, dtTo) FROM inserted) <> (select lDuration FROM inserted) ) 
        begin
          	select @errorNumber = 30003, @errorMsg = 'Die Differenz zwischen Von und Bis und die Dauer mssen bereinstimmen'
           	goto errorHandler
        end
      end
    end

  end

  return
errorHandler:
  raiserror @errorNumber @errorMsg
  rollback transaction
END

GO


/****** Objekt: Benutzername TimeSafe_usr    Skriptdatum: 06.03.01 15:09:27 ******/
if not exists (select * from master..syslogins where name = N'TimeSafe_usr')
BEGIN
	declare @logindb nvarchar(132), @loginlang nvarchar(132) select @logindb = N'TimeSafe', @loginlang = N'us_english'
	if @logindb is null or not exists (select * from master..sysdatabases where name = @logindb)
		select @logindb = N'master'
	if @loginlang is null or (not exists (select * from master..syslanguages where name = @loginlang) and @loginlang <> N'us_english')
		select @loginlang = @@language
	exec sp_addlogin N'TimeSafe_usr', 'T1m3$Afe2fG7', @logindb, @loginlang
END
GO

/****** Objekt:  Benutzer TimeSafe_usr    Skriptdatum: 06.03.01 15:09:27 ******/
if not exists (select * from sysusers where name = N'TimeSafe_usr' and uid < 16382)
	EXEC sp_grantdbaccess N'TimeSafe_usr', N'TimeSafe_usr'
GO


SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


/* Zu den Rollen datreader und datawriter hinzufgen */
exec sp_addrolemember 'db_datareader', 'TimeSafe_usr'
exec sp_addrolemember 'db_datawriter', 'TimeSafe_usr'
go


SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

/****** Stammdaten einfllen ******/

/* Tabelle tInvoiceConditions */
insert into tMasterInvConditions (strDesignation, lTermOfPayment) values
				 ('10 Tage netto', 10)

insert into tMasterInvConditions (strDesignation, lTermOfPayment) values
				 ('30 Tage netto', 30)

/* Standard Faktura-Report-Definition eintragen				*/
/* Das ist die Definition selbst					*/
insert into tInvoiceRptDefinition (strDesignation) values ('Standard')
go

/* Layout Deckblatt							*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 1, 'Invoice.rpx')
go

/* Layout Einzahlungsschein						*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 2, 'CreditSlip.rpx')
go

/* Layout Zeitleistungen						*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 3, 'TimeEntriesBookedList.rpx')
go

/* Layout Spesenleistungen						*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 4, 'ExpenseEntriesBookedList.rpx')
go

/* Layout Materialleistungen						*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 5, 'MaterialEntriesBookedList.rpx')
go

/* Layout Pauschalleistungen						*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 6, 'LumpSumsEntriesBookedList.rpx')
go

/* Layout Honorare							*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 7, 'FeesEntriesBookedList.rpx')
go

/* Layout Akontoeintrge						*/
insert into tInvoiceRptFile (lInvoiceRptDefinitionID, lSheetType, strInvRptFile) values (1, 8, 'AccPayEntriesBookedList.rpx')
go

/* Zusatzeinstellungen Zeitleistungen					*/
insert into tTimeSrvRpt (lInvoiceRptDefinitionID, lSheetType, bDspEffectiveDuration, bDspGlobalInvEntries, bGroupByProjectGroups, bDspTextOnly, bDspNoText) values
			(1, 3, 0, 0, 0, 0, 0)
go

/* Zusatzeinstellungen Spesenleistungen					*/
insert into tExpenseSrvRpt (lInvoiceRptDefinitionID, lSheetType, bDspEffectiveAmount, bDspGlobalInvEntries) values
			(1, 4, 0, 0)
go

/* Zusatzeinstellungen Materialleistungen				*/
insert into tMaterialSrvRpt (lInvoiceRptDefinitionID, lSheetType, bDspEffectiveAmount) values
			(1, 5, 0)
go


/* Tabelle tSettings */

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (1, 0, 0, 'ID der Systemsprache')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (2, 1, 0, 'ID der Ferienttigkeit')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (3, 42, 0, 'Arbeitszeit pro Woche in Stunden')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (4, 5, 0, 'Anzahl Arbeitstage pro Woche')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (5, 1, 0, 'Von der Organisation bevorzugter Arbeitsmodus (von bis=1 oder Dauer=2)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (6, 0, 'Zeiteintrge konsolidieren')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (7, 70, 0, 'Interner Stundensatz eines Mitarbeiters')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (8, 140, 0, 'Externer Stundensatz eines Mitarbeiters')

insert into tSettings (lSettingID, strValue, bValue, strDescription) values 
		      (9, '0211000000000', 0, 'Berechtigungsstring fr einen neuen Mitarbeiter')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (10, 20, 0, 'Maximale Anzahl Favoriten pro Benutzer')

insert into tSettings (lSettingID, strValue, bValue, strDescription) values 
		      (11, '0111110', 0, 'Arbeitstage der Woche (beginnend beim Sonntag), Tag an dem gearbeitet wird = 1')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (12, 1, 0, 'ID der Stammwhrung')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (13, 1, 0, 'ID des Default Mehrwertsteuerschlssels')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (14, 1, 0, 'ID des Default Ertragskontos')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (15, 2, 0, 'ID des Default Aufwandskontos')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (16, 3, 0, 'ID des Default Aktivkontos')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (17, 4, 0, 'ID des Default Passivkontos')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (18, 2, 0, 'ID der Default Zahlungskondition')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (19, 0, 'Default Fakturierungsbemerkungen')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (20, 0, 'Default Fakturierungstext')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (21, 0, 'Defaultzeit in Tagen, nachdem gemahnt wird')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (22, 20, 0, 'Default Ferienanspruch pro Jahr fr Mitarbeiter')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (23, 0, 'MWSt.-Nummer')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (24, 1, 0, 'Ausrichtung des Logos fr die Berichte (1 = linksbndig, 2 = rechtsbndig)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (25, 0, 'Grafik fr die Reports')

insert into tSettings (lSettingID, strValue, bValue, strDescription) values 
		      (26, 'TimeSafe', 0, 'Freigabe auf dem Server')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (27, 2, 0, 'Linker Rand auf den Reports (in cm)')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (28, 2, 0, 'Rechter Rand auf den Reports (in cm)')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (29, 1.5, 0, 'Rand oben auf den Reports (in cm) ')

insert into tSettings (lSettingID, dblValue, bValue, strDescription) values 
		      (30, 1.5, 0, 'Rand unten auf den Reports (in cm)')

insert into tSettings (lSettingID, strValue, bValue, strDescription) values 
		      (31, 'Ae49rH', 0, 'Super User Passwort')

insert into tSettings (lSettingID, bValue, dtValue, strDescription) values 
		      (32, 0, GETDATE(), 'Systemstart')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (33, 0, 'Pfad Mandant (String Wert)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (34, 0, 'Passwort Mandant (String Wert)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (35, 0, 'Kontonummer Debitorkonto in FIBU (Long Wert)')

insert into tSettings (lSettingID, strValue, bValue, strDescription) values 
		      (36, '@', 0, 'Spezialzeichen das vor den Buchungstext gesetzt wird')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (37, 1, 0, 'Nchste freie Belegnummer Rechnung')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (38, 10000, 0, 'Nchste freie Belegnummer Zahlung')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (39, 1, 0, 'Art der MWSt.-Verrechnung (1 = vereinbart, 2 = vereinnahmt')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (40, 0, 'Bezeichnung auf Faktura fr Zeitleistungen')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (41, 0, 'Bezeichnung auf Faktura fr Spesenleistungen')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (42, 0, 'Bezeichnung auf Faktura fr Materialleistungen')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (43, 0, 'Bezeichnung auf Faktura fr Pauschalleistungen')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (44, 0, 'Bezeichnung auf Faktura fr Honorarleistungen')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (45, 0, 'Bezeichnung auf Faktura fr Projekt | Mandat')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (46, 380, 0, 'Version der Datenbank')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (47, 1, 'Kontakte in Uebersicht anzeigen')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (48, 2, 0, 'Art der Verbuchungsart (1=ins Hauptbuch, 2=ins Nebenbuch)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (49, 0, 'Falls PK nicht vorhanden -> PK erstellen')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (50, 1, 0, 'Art der VESR/BESR (1=Bank, 2=Post)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (51, 0, 'ESR Kundennummer')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (52, 0, 'Firmenadresse (zugunsten von)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (53, 0, 'Bank (Einzahlung fr)')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (54, 3, 0, 'ID Aktivkontos fuer eingehende Zahlungen. Konto-Nr. Bank fuer ESR')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (55, 0, 'Bezeichnung auf Faktura fr Akonto')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (56, 0, 'Pfad fr Projekt Dokumente')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (57, 15, 0, 'Intervall in Minuten. Erinnerungsfunktion fuer Aufgaben')

insert into tSettings (lSettingID, strValue, bValue, strDescription) values 
		      (58, 'www.timesafe.ch/hilfe/fragen.asp', 0, 'Seite fr Online-Support-Anfragen')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (59, 1, 0, 'Default Faktura-Report-Definition')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values
		      (60, 100, 0, 'Version der Personaleinsatzplanung Datenbank')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (61, 15, 0, 'Minuten Einheit fr das Runden')

insert into tSettings (lSettingID, lValue, bValue, strDescription) values 
		      (62, 1, 0, 'Art der Rundung (1=aufrunden, 2=abrunden, 3=mathematisch)')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (63, 0, 'Journalisierungsdatum')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (64, 0, 'Bezeichnung auf Faktura fr MWST')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (65, 0, 'MWST Abrechnung nach Saldosteuersatz')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (66, 0, 'Nummernkreis Faktura-Nummern')

insert into tSettings (lSettingID, bValue, strDescription) values 
		      (67, 0, 'Faktura-Status nach Erstellung')
		      
insert into tSettings (lSettingID, bValue, strDescription) values 
		      (68, 0, 'Journalisierungsdatum Umbuchen')

GO


/* Feiertage einfgen, die jedes Jahr vorkommen und immer gltig sind */
insert into tMasterPubHolidays (strDesignation, dtDate, decDuration, bValidEveryYear) values
			      ('Neujahr', CONVERT(datetime, '2001-01-01 00:00:00', 120), 1, 1)
insert into tMasterPubHolidays (strDesignation, dtDate, decDuration, bValidEveryYear) values
			      ('Weihnachten', CONVERT(datetime, '2001-12-25 00:00:00', 120), 1, 1)
insert into tMasterPubHolidays (strDesignation, dtDate, decDuration, bValidEveryYear) values
			      ('Stefanstag', CONVERT(datetime, '2001-12-26 00:00:00', 120), 1, 1)

	
	
/* Tabelle tEmployees */
/* Administrator Account */
insert into tEmployees (lPersonalNo, strLogin, strPwd, strLastName, strFirstName, dtEntryDate,
			decExternallyHourlyRate, bUseHourlyRateAlways, strRights, bConsolidateTime, 
			tinPrefWorkMode, bFreeDef1, bFreeDef2, bFreeDef3, bFreeDef4, bFastLogin, bUseRounding, strCreator, dtCreated) values
			(0, 'Administrator', 'pass', 'Administrator', ' ', GETDATE(),
			 140, 0, '1222222222121', 0, 
			 1, 0, 0, 0, 0, 0, 0, 'Administrator', GETDATE())

/* Anstellungs Eintrag */
insert into tEmployment (lEmployeeID, dtValidFrom, decPercent) values
						(1, GETDATE(), 100)

/* Interner Stundensatz Eintrag */
insert into tIntHourlyRate (lEmployeeID, dtValidFrom, decHourlyRate) values
						(1, GETDATE(), 70)

/* Ferienguthaben Eintrag */
insert into tCreditBalanceCorrections (lEmployeeID, decHolidayClaim, decCarry, dtDate) values
									  (1, 20, 0, GETDATE())

/* Eintrge der Funktionsstufen */
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (1, 'Funktionsstufe 1', 0, 1)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (2, 'Funktionsstufe 2', 0, 2)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (3, 'Funktionsstufe 3', 0, 3)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (4, 'Funktionsstufe 4', 0, 4)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (5, 'Funktionsstufe 5', 0, 5)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (6, 'Funktionsstufe 6', 0, 6)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (7, 'Funktionsstufe 7', 0, 7)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (8, 'Funktionsstufe 8', 0, 8)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (9, 'Funktionsstufe 9', 0, 9)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (10, 'Funktionsstufe 10', 0, 10)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (11, 'Funktionsstufe 11', 0, 11)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (12, 'Funktionsstufe 12', 0, 12)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (13, 'Funktionsstufe 13', 0, 13)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (14, 'Funktionsstufe 14', 0, 14)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (15, 'Funktionsstufe 15', 0, 15)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (16, 'Funktionsstufe 16', 0, 16)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (17, 'Funktionsstufe 17', 0, 17)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (18, 'Funktionsstufe 18', 0, 18)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (19, 'Funktionsstufe 19', 0, 19)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (20, 'Funktionsstufe 20', 0, 20)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (21, 'Funktionsstufe 21', 0, 21)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (22, 'Funktionsstufe 22', 0, 22)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (23, 'Funktionsstufe 23', 0, 23)
insert into tScale (lScaleID, strDesignation, bUsed, lSortKey) values
		       (24, 'Funktionsstufe 24', 0, 24)



/* Tabelle tLanguages */
insert into tLanguages (lLanguageID, strDesignation, bInvoiceOnly) values
		       (0, 'Deutsch (Projekt)', 0)
insert into tLanguages (lLanguageID, strDesignation, bInvoiceOnly) values
		       (4000, 'English', 0)
insert into tLanguages (lLanguageID, strDesignation, bInvoiceOnly) values
		       (8000, 'Franais', 0)
insert into tLanguages (lLanguageID, strDesignation, bInvoiceOnly) values
		       (12000, 'Deutsch (Mandat)', 0)
insert into tLanguages (lLanguageID, strDesignation, bInvoiceOnly) values
		       (16000, 'Italiano', 0)

/* Tabelle tMasterAccounts */
/* Ertragskonto */
insert into tMasterAccounts (strAccountNo, strDesignation, tinType) values
			    ('3000', 'Ertragskonto', 1)
/* Aufwandskonto */
insert into tMasterAccounts (strAccountNo, strDesignation, tinType) values
			    ('4000', 'Aufwandskonto', 2)
/* Aktivkonto */
insert into tMasterAccounts (strAccountNo, strDesignation, tinType) values
			    ('1000', 'Aktivkonto', 3)
/* Passivkonto */
insert into tMasterAccounts (strAccountNo, strDesignation, tinType) values
			    ('2000', 'Passivkonto', 4)

/* Tabelle tMasterCurrencies */
insert into tMasterCurrencies (strCurrency, decFactor, dtValidAt) values
			      ('CHF', 1, CONVERT(datetime, '2001-01-01 00:00:00', 120))

/* Tabelle tMasterActivities */
/* Ferienttigkeit */
insert into tMasterActivities (lIncomeAccountID, lCurrencyID, strDesignation, decHourlyRate, bUseEmpHRate, bActive) values
			      (1, 1, 'Ferien', 0, 0, 1)


/* Mehrwersteuerschlssel mit Gltigkeit */
insert into tMasterTaxKeys (lPassiveAccountID, strDesignation, bActive) values
			   (4, 'USt76', 1)

insert into tTaxKeyValidities (lTaxKeyID, decPercentage, dtValidFrom) values
			      (1, 7.6, CONVERT(datetime, '2001-01-01 00:00:00', 120))

insert into tLicenseKey (strLicenseKey) values
			      ('1aG45hz748Be4TiX92') 

go


